/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl.hive;

import java.util.List;
import java.util.Properties;
import org.apache.kylin.metrics.lib.ActiveReservoir;
import org.apache.kylin.metrics.lib.ActiveReservoirListener;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.metrics.lib.Record;
import org.apache.kylin.metrics.lib.impl.ReporterBuilder;
import org.apache.kylin.metrics.lib.impl.hive.HiveProducer;
import org.apache.kylin.metrics.lib.impl.hive.HiveSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveReservoirReporter
extends ActiveReservoirReporter {
    public static final String HIVE_REPORTER_SUFFIX = "HIVE";
    public static final HiveSink sink = new HiveSink();
    protected static final Logger logger = LoggerFactory.getLogger(HiveReservoirReporter.class);
    private final ActiveReservoir activeReservoir;
    private final HiveReservoirListener listener;

    public HiveReservoirReporter(ActiveReservoir activeReservoir, Properties props) throws Exception {
        this.activeReservoir = activeReservoir;
        this.listener = new HiveReservoirListener(props);
    }

    public static Builder forRegistry(ActiveReservoir activeReservoir) {
        return new Builder(activeReservoir);
    }

    public static String getTableFromSubject(String subject) {
        return sink.getTableFromSubject(subject);
    }

    public void start() {
        this.activeReservoir.addListener((ActiveReservoirListener)this.listener);
    }

    public void stop() {
        this.activeReservoir.removeListener((ActiveReservoirListener)this.listener);
    }

    public void close() {
        this.stop();
    }

    private class HiveReservoirListener
    implements ActiveReservoirListener {
        HiveProducer producer;

        private HiveReservoirListener(Properties props) throws Exception {
            this.producer = new HiveProducer(props);
        }

        public boolean onRecordUpdate(List<Record> records) {
            try {
                this.producer.send(records);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }

        public boolean onRecordUpdate(Record record) {
            try {
                this.producer.send(record);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }

        public void close() {
            this.producer.close();
        }
    }

    public static class Builder
    extends ReporterBuilder {
        private Builder(ActiveReservoir activeReservoir) {
            super(activeReservoir);
        }

        private void setFixedProperties() {
        }

        public HiveReservoirReporter build() throws Exception {
            this.setFixedProperties();
            return new HiveReservoirReporter(this.registry, this.props);
        }
    }
}

