/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import org.apache.logging.log4j.plugins.di.DependencyChain;
import org.apache.logging.log4j.plugins.di.InjectException;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.util.StringBuilders;

public class NotInjectableException
extends InjectException {
    public NotInjectableException(Class<?> injectClass) {
        this(DependencyChain.empty(), injectClass);
    }

    public NotInjectableException(Key<?> key) {
        this(DependencyChain.empty(), key);
    }

    public NotInjectableException(Key<?> key, DependencyChain dependencies) {
        this(dependencies, key);
    }

    private NotInjectableException(DependencyChain chain, Object target) {
        super(NotInjectableException.formatMessage(target, chain));
    }

    private static String formatMessage(Object target, DependencyChain dependencies) {
        StringBuilder sb = new StringBuilder("No @Inject constructor or default constructor found for ");
        if (!dependencies.isEmpty()) {
            sb.append("chain ");
            for (Key dependency : dependencies) {
                dependency.formatTo(sb);
                sb.append(" -> ");
            }
        }
        StringBuilders.appendValue((StringBuilder)sb, (Object)target);
        return sb.toString();
    }
}

