/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;

public final class AnnotationUtil {
    public static boolean isMetaAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> metaAnnotation) {
        return AnnotationUtil.getMetaAnnotation(element, metaAnnotation) != null;
    }

    public static Annotation getMetaAnnotation(AnnotatedElement element, Class<? extends Annotation> metaAnnotation) {
        return AnnotationUtil.findMetaAnnotation(element, metaAnnotation, new HashSet<Class<? extends Annotation>>());
    }

    private static Annotation findMetaAnnotation(AnnotatedElement element, Class<? extends Annotation> metaAnnotation, Set<Class<? extends Annotation>> seen) {
        for (Annotation annotation : element.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!seen.add(annotationType)) continue;
            if (annotationType.isAnnotationPresent(metaAnnotation)) {
                return annotation;
            }
            Annotation original = AnnotationUtil.findMetaAnnotation(annotationType, metaAnnotation, seen);
            if (original == null) continue;
            return original;
        }
        return null;
    }

    public static <A extends Annotation> A getLogicalAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return AnnotationUtil.findLogicalAnnotation(element, annotationType, new HashSet<Class<? extends Annotation>>());
    }

    private static <A extends Annotation> A findLogicalAnnotation(AnnotatedElement element, Class<A> annotationType, Set<Class<? extends Annotation>> seen) {
        A elementAnnotation = element.getAnnotation(annotationType);
        if (elementAnnotation != null) {
            return elementAnnotation;
        }
        for (Annotation annotation : element.getAnnotations()) {
            A ann;
            Class<? extends Annotation> metaAnnotationType = annotation.annotationType();
            if (!seen.add(metaAnnotationType) || (ann = AnnotationUtil.findLogicalAnnotation(metaAnnotationType, annotationType, seen)) == null) continue;
            return ann;
        }
        return null;
    }

    private AnnotationUtil() {
    }
}

