/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.visit;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Function;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Named;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.convert.TypeConverter;
import org.apache.logging.log4j.plugins.di.Injector;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.visit.NodeVisitor;
import org.apache.logging.log4j.util.StringBuilders;

public class PluginBuilderAttributeVisitor
implements NodeVisitor {
    private final Function<String, String> stringSubstitutionStrategy;
    private final Injector injector;

    @Inject
    public PluginBuilderAttributeVisitor(@Named(value={"StringSubstitutor"}) @Named(value={"StringSubstitutor"}) Function<String, String> stringSubstitutionStrategy, Injector injector) {
        this.stringSubstitutionStrategy = stringSubstitutionStrategy;
        this.injector = injector;
    }

    protected boolean isSensitive(AnnotatedElement element) {
        return element.getAnnotation(PluginBuilderAttribute.class).sensitive();
    }

    @Override
    public Object visitField(Field field, Node node, StringBuilder debugLog) {
        String name = Keys.getName(field);
        Collection<String> aliases = Keys.getAliases(field);
        Type targetType = field.getGenericType();
        TypeConverter<?> converter = this.injector.getTypeConverter(targetType);
        boolean sensitive = this.isSensitive(field);
        Object value = node.removeMatchingAttribute(name, aliases).map(this.stringSubstitutionStrategy.andThen(s -> converter.convert((String)s, null, sensitive))).orElse(null);
        StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)name, (Object)(sensitive ? "(***)" : value), (CharSequence)", ");
        return value;
    }

    @Override
    public Object visitParameter(Parameter parameter, Node node, StringBuilder debugLog) {
        String name = Keys.getName(parameter);
        Collection<String> aliases = Keys.getAliases(parameter);
        Type targetType = parameter.getParameterizedType();
        TypeConverter<?> converter = this.injector.getTypeConverter(targetType);
        boolean sensitive = this.isSensitive(parameter);
        Object value = node.removeMatchingAttribute(name, aliases).map(this.stringSubstitutionStrategy.andThen(s -> converter.convert((String)s, null, sensitive))).orElse(null);
        StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)name, (Object)(sensitive ? "(***)" : value), (CharSequence)", ");
        return value;
    }
}

