/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class DeltaList<E> {
    private final List<E> added;
    private final List<E> removed;
    private final boolean hasChanged;

    DeltaList(Collection<E> oldList, Collection<E> newList) {
        this.added = new ArrayList<E>(newList);
        this.removed = new ArrayList<E>(oldList);
        this.added.removeAll(oldList);
        this.removed.removeAll(newList);
        this.hasChanged = !this.added.isEmpty() || !this.removed.isEmpty();
    }

    Collection<E> getAdded() {
        return Collections.unmodifiableCollection(this.added);
    }

    Collection<E> getRemoved() {
        return Collections.unmodifiableCollection(this.removed);
    }

    boolean hasChanged() {
        return this.hasChanged;
    }
}

