/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-scm-plugin:1.7", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven SCM Plugin", 0);
        this.append(sb, "Maven Plugin that allows accessing different SCMs.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 19 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "add".equals(this.goal)) {
            this.append(sb, "scm:add", 0);
            this.append(sb, "Add a file set to the project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "bootstrap".equals(this.goal)) {
            this.append(sb, "scm:bootstrap", 0);
            this.append(sb, "Pull the project source from the configured scm and execute the configured goals.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkoutDirectory (Default: ${project.build.directory}/checkout)", 2);
                this.append(sb, "The directory to checkout the sources to for the bootstrap and checkout goals.", 3);
                this.append(sb, "Expression: ${checkoutDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals", 2);
                this.append(sb, "The goals to run on the clean checkout of a project for the bootstrap goal. If none are specified, then the default goal for the project is executed. Multiple goals should be comma separated.", 3);
                this.append(sb, "Expression: ${goals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goalsDirectory", 2);
                this.append(sb, "The subdirectory (under the project directory) in which to run the goals. The project directory is the same as the checkout directory in most cases, but for some SCMs, it is a subdirectory of the checkout directory.", 3);
                this.append(sb, "Expression: ${goalsDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "profiles", 2);
                this.append(sb, "A list of profiles to run with the goals. Multiple profiles must be comma separated with no spaces.", 3);
                this.append(sb, "Expression: ${profiles}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${scmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${scmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipCheckoutIfExists (Default: false)", 2);
                this.append(sb, "Skip checkout if checkoutDirectory exists.", 3);
                this.append(sb, "Expression: ${skipCheckoutIfExists}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useExport", 2);
                this.append(sb, "Use Export instead of checkout", 3);
                this.append(sb, "Expression: ${useExport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "branch".equals(this.goal)) {
            this.append(sb, "scm:branch", 0);
            this.append(sb, "Branch the project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "branch", 2);
                this.append(sb, "The branch name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${branch}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "message", 2);
                this.append(sb, "The message applied to the tag creation.", 3);
                this.append(sb, "Expression: ${message}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteBranching (Default: true)", 2);
                this.append(sb, "currently only implemented with svn scm. Enable a workaround to prevent issue due to svn client > 1.5.0 (http://jira.codehaus.org/browse/SCM-406)", 3);
                this.append(sb, "Expression: ${remoteBranching}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "changelog".equals(this.goal)) {
            this.append(sb, "scm:changelog", 0);
            this.append(sb, "Dump changelog contents to console. It is mainly used to test maven-scm-api's changelog command.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dateFormat", 2);
                this.append(sb, "Date Format in changelog output of scm tool.", 3);
                this.append(sb, "Expression: ${dateFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "endDate", 2);
                this.append(sb, "End Date.", 3);
                this.append(sb, "Expression: ${endDate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "endScmVersion", 2);
                this.append(sb, "End Scm Version.", 3);
                this.append(sb, "Expression: ${endScmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "endScmVersionType", 2);
                this.append(sb, "End Scm Version Type.", 3);
                this.append(sb, "Expression: ${endScmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${scmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersionType", 2);
                this.append(sb, "The version type (branch/tag) of scmVersion.", 3);
                this.append(sb, "Expression: ${scmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "startDate", 2);
                this.append(sb, "Start Date.", 3);
                this.append(sb, "Expression: ${startDate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "startScmVersion", 2);
                this.append(sb, "Start Scm Version.", 3);
                this.append(sb, "Expression: ${startScmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "startScmVersionType", 2);
                this.append(sb, "Start Scm Version Type.", 3);
                this.append(sb, "Expression: ${startScmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userDateFormat (Default: yyyy-MM-dd)", 2);
                this.append(sb, "Date format to use for the specified startDate and/or endDate.", 3);
                this.append(sb, "Expression: ${userDateFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "check-local-modification".equals(this.goal)) {
            this.append(sb, "scm:check-local-modification", 0);
            this.append(sb, "This mojo will fail the build if there is any local modifications", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "errorMessage (Default: The build will stop as there is local modifications)", 2);
                this.append(sb, "Custom error message", 3);
                this.append(sb, "Expression: ${scm.checkLocalModification.errorMessage}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Custom error message", 3);
                this.append(sb, "Expression: ${scm.checkLocalModification.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "checkin".equals(this.goal)) {
            this.append(sb, "scm:checkin", 0);
            this.append(sb, "Commit changes to the configured scm url.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: developerConnection)", 2);
                this.append(sb, "The configured scm url to use.", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "message", 2);
                this.append(sb, "Commit log.", 3);
                this.append(sb, "Expression: ${message}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${scmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${scmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "checkout".equals(this.goal)) {
            this.append(sb, "scm:checkout", 0);
            this.append(sb, "Get a fresh copy of the latest source from the configured scm url.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkoutDirectory (Default: ${project.build.directory}/checkout)", 2);
                this.append(sb, "The directory to checkout the sources to for the bootstrap and checkout goals.", 3);
                this.append(sb, "Expression: ${checkoutDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${scmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${scmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipCheckoutIfExists (Default: false)", 2);
                this.append(sb, "Skip checkout if checkoutDirectory exists.", 3);
                this.append(sb, "Expression: ${skipCheckoutIfExists}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useExport", 2);
                this.append(sb, "Use Export instead of checkout", 3);
                this.append(sb, "Expression: ${useExport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "diff".equals(this.goal)) {
            this.append(sb, "scm:diff", 0);
            this.append(sb, "Display the difference of the working copy with the latest copy in the configured scm url.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "endScmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${startScmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "endScmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${endScmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile (Default: ${project.artifactId}.diff)", 2);
                this.append(sb, "Output file name.", 3);
                this.append(sb, "Expression: ${outputFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "startScmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${startScmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "startScmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${startScmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "edit".equals(this.goal)) {
            this.append(sb, "scm:edit", 0);
            this.append(sb, "Edit/lock a set of files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "export".equals(this.goal)) {
            this.append(sb, "scm:export", 0);
            this.append(sb, "Get a fresh exported copy of the latest source from the configured scm url.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "exportDirectory (Default: ${project.build.directory}/export)", 2);
                this.append(sb, "The directory to export the sources to.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${exportDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${scmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${scmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipExportIfExists (Default: false)", 2);
                this.append(sb, "Skip export if exportDirectory exists.", 3);
                this.append(sb, "Expression: ${skipExportIfExists}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "scm:help", 0);
            this.append(sb, "Display help information on maven-scm-plugin.\nCall\n\u00a0\u00a0mvn\u00a0scm:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "list".equals(this.goal)) {
            this.append(sb, "scm:list", 0);
            this.append(sb, "Get the list of project files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "recursive (Default: true)", 2);
                this.append(sb, "Use recursive mode.", 3);
                this.append(sb, "Expression: ${recursive}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${scmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${scmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "remove".equals(this.goal)) {
            this.append(sb, "scm:remove", 0);
            this.append(sb, "Mark a set of files for deletion.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "message", 2);
                this.append(sb, "The commit message.", 3);
                this.append(sb, "Expression: ${message}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "status".equals(this.goal)) {
            this.append(sb, "scm:status", 0);
            this.append(sb, "Display the modification status of the files in the configured scm url.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "tag".equals(this.goal)) {
            this.append(sb, "scm:tag", 0);
            this.append(sb, "Tag the project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addTimestamp (Default: false)", 2);
                this.append(sb, "Use timestamp tagging.", 3);
                this.append(sb, "Expression: ${addTimestamp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "message", 2);
                this.append(sb, "The message applied to the tag creation.", 3);
                this.append(sb, "Expression: ${message}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteTagging (Default: true)", 2);
                this.append(sb, "currently only implemented with svn scm. Enable a workaround to prevent issue due to svn client > 1.5.0 (http://jira.codehaus.org/browse/SCM-406)", 3);
                this.append(sb, "Expression: ${remoteTagging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The tag name.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampFormat (Default: yyyyMMddHHmmss)", 2);
                this.append(sb, "Set the timestamp format.", 3);
                this.append(sb, "Expression: ${timestampFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampPosition (Default: end)", 2);
                this.append(sb, "Define the timestamp position (end or begin).", 3);
                this.append(sb, "Expression: ${timestampPosition}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampPrefix (Default: -)", 2);
                this.append(sb, "Timestamp tag prefix.", 3);
                this.append(sb, "Expression: ${timestampPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "unedit".equals(this.goal)) {
            this.append(sb, "scm:unedit", 0);
            this.append(sb, "Unedit/unlock a set of files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update".equals(this.goal)) {
            this.append(sb, "scm:update", 0);
            this.append(sb, "Update the local working copy with the latest source from the configured scm url.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "revisionKey (Default: scm.revision)", 2);
                this.append(sb, "The project property where to store the revision name.", 3);
                this.append(sb, "Expression: ${revisionKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "runChangelog (Default: false)", 2);
                this.append(sb, "Run Changelog after update.", 3);
                this.append(sb, "Expression: ${runChangelog}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${scmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${scmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-subprojects".equals(this.goal)) {
            this.append(sb, "scm:update-subprojects", 0);
            this.append(sb, "Updates all projects in a multi project build. This is useful for users who have adopted the flat project structure where the aggregator project is a sibling of the sub projects rather than sitting in the parent directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "revisionKey (Default: scm.revision)", 2);
                this.append(sb, "The project property where to store the revision name.", 3);
                this.append(sb, "Expression: ${revisionKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersion", 2);
                this.append(sb, "The version (revision number/branch name/tag name).", 3);
                this.append(sb, "Expression: ${scmVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmVersionType", 2);
                this.append(sb, "The version type (branch/tag/revision) of scmVersion.", 3);
                this.append(sb, "Expression: ${scmVersionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "validate".equals(this.goal)) {
            this.append(sb, "scm:validate", 0);
            this.append(sb, "Validate scm connection string.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionType (Default: connection)", 2);
                this.append(sb, "The type of connection to use (connection or developerConnection).", 3);
                this.append(sb, "Expression: ${connectionType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection URL.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developerConnectionUrl (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The SCM connection URL for developers.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of excludes file pattern.", 3);
                this.append(sb, "Expression: ${excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separated list of includes file pattern.", 3);
                this.append(sb, "Expression: ${includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "passphrase", 2);
                this.append(sb, "The passphrase (used by java svn).", 3);
                this.append(sb, "Expression: ${passphrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The user password (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "privateKey", 2);
                this.append(sb, "The private key (used by java svn).", 3);
                this.append(sb, "Expression: ${privateKey}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "List of provider implementations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Should distributed changes be pushed to the central repository? For many distributed SCMs like Git, a change like a commit is only stored in your local copy of the repository. Pushing the change allows your to more easily share it with other users.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmConnection (Default: ${project.scm.connection})", 2);
                this.append(sb, "The scm connection url.", 3);
                this.append(sb, "Expression: ${scmConnection}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmDeveloperConnection (Default: ${project.scm.developerConnection})", 2);
                this.append(sb, "The scm connection url for developers.", 3);
                this.append(sb, "Expression: ${scmDeveloperConnection}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The url of tags base directory (used by svn protocol). It is not necessary to set it if you use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The user name (used by svn, starteam and perforce protocol).", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "The working directory.", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List<String> lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

