/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.TimestampOracleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PausableTimestampOracle
extends TimestampOracleImpl {
    private static final Logger LOG = LoggerFactory.getLogger(PausableTimestampOracle.class);
    private volatile boolean tsoPaused = false;

    @Inject
    public PausableTimestampOracle(MetricsRegistry metrics, TimestampStorage tsStorage, Panicker panicker) throws IOException {
        super(metrics, tsStorage, panicker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next() {
        while (this.tsoPaused) {
            PausableTimestampOracle pausableTimestampOracle = this;
            synchronized (pausableTimestampOracle) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted whilst paused");
                    Thread.currentThread().interrupt();
                }
            }
        }
        return super.next();
    }

    public synchronized void pause() {
        this.tsoPaused = true;
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized void resume() {
        this.tsoPaused = false;
        ((Object)((Object)this)).notifyAll();
    }

    public boolean isTSOPaused() {
        return this.tsoPaused;
    }
}

