/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.codahale.metrics.MetricRegistry;
import com.lmax.disruptor.WorkHandler;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.Histogram;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.Timer;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PersistEvent;
import org.apache.omid.tso.PersistenceProcessorImpl;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.RetryProcessor;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.MoreObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceProcessorHandler
implements WorkHandler<PersistenceProcessorImpl.PersistBatchEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceProcessorHandler.class);
    @VisibleForTesting
    static final AtomicInteger consecutiveSequenceCreator = new AtomicInteger(0);
    private final String id = String.valueOf(consecutiveSequenceCreator.getAndIncrement());
    private final String tsoHostAndPort;
    private final LeaseManagement leaseManager;
    private final ReplyProcessor replyProcessor;
    private final RetryProcessor retryProcessor;
    private final CommitTable.Writer writer;
    final Panicker panicker;
    private final Timer flushTimer;
    private final Histogram batchSizeHistogram;
    private final Histogram flushedCommitEventsHistogram;

    @Inject
    PersistenceProcessorHandler(MetricsRegistry metrics, String tsoHostAndPort, LeaseManagement leaseManager, CommitTable commitTable, ReplyProcessor replyProcessor, RetryProcessor retryProcessor, Panicker panicker) throws InterruptedException, ExecutionException, IOException {
        this.tsoHostAndPort = tsoHostAndPort;
        this.leaseManager = leaseManager;
        this.writer = commitTable.getWriter();
        this.replyProcessor = replyProcessor;
        this.retryProcessor = retryProcessor;
        this.panicker = panicker;
        String flushTimerName = MetricRegistry.name((String)"tso", (String[])new String[]{"persistence-processor-handler", this.id, "flush", "latency"});
        this.flushTimer = metrics.timer(flushTimerName);
        String flushedCommitEventsName = MetricRegistry.name((String)"tso", (String[])new String[]{"persistence-processor-handler", this.id, "flushed", "commits", "size"});
        this.flushedCommitEventsHistogram = metrics.histogram(flushedCommitEventsName);
        String batchSizeMetricsName = MetricRegistry.name((String)"tso", (String[])new String[]{"persistence-processor-handler", this.id, "batch", "size"});
        this.batchSizeHistogram = metrics.histogram(batchSizeMetricsName);
    }

    public String getId() {
        return this.id;
    }

    public void onEvent(PersistenceProcessorImpl.PersistBatchEvent batchEvent) throws Exception {
        PersistEvent event;
        int i;
        int commitEventsToFlush = 0;
        Batch batch = batchEvent.getBatch();
        int numOfBatchedEvents = batch.getNumEvents();
        this.batchSizeHistogram.update(numOfBatchedEvents);
        block14: for (i = 0; i < numOfBatchedEvents; ++i) {
            event = batch.get(i);
            switch (event.getType()) {
                case TIMESTAMP: {
                    event.getMonCtx().timerStop("persistence.processor.timestamp.latency");
                    continue block14;
                }
                case COMMIT: {
                    this.writer.addCommittedTransaction(event.getStartTimestamp(), event.getCommitTimestamp());
                    ++commitEventsToFlush;
                    continue block14;
                }
                case COMMIT_RETRY: {
                    event.getMonCtx().timerStop("persistence.processor.commit-retry.latency");
                    continue block14;
                }
                case ABORT: {
                    event.getMonCtx().timerStop("persistence.processor.abort.latency");
                    continue block14;
                }
                case FENCE: {
                    this.writer.addCommittedTransaction(event.getCommitTimestamp(), event.getCommitTimestamp());
                    ++commitEventsToFlush;
                    continue block14;
                }
                default: {
                    throw new IllegalStateException("Event not allowed in Persistent Processor Handler: " + event);
                }
            }
        }
        this.flush(commitEventsToFlush);
        this.filterAndDissambiguateClientRetries(batch);
        block15: for (i = 0; i < batch.getNumEvents(); ++i) {
            event = batch.get(i);
            switch (event.getType()) {
                case TIMESTAMP: {
                    event.getMonCtx().timerStart("reply.processor.timestamp.latency");
                    continue block15;
                }
                case COMMIT: {
                    event.getMonCtx().timerStop("persistence.processor.commit.latency");
                    event.getMonCtx().timerStart("reply.processor.commit.latency");
                    continue block15;
                }
                case COMMIT_RETRY: {
                    throw new IllegalStateException("COMMIT_RETRY events must be filtered before this step: " + event);
                }
                case ABORT: {
                    event.getMonCtx().timerStart("reply.processor.abort.latency");
                    continue block15;
                }
                case FENCE: {
                    event.getMonCtx().timerStop("persistence.processor.fence.latency");
                    event.getMonCtx().timerStart("reply.processor.fence.latency");
                    continue block15;
                }
                default: {
                    throw new IllegalStateException("Event not allowed in Persistent Processor Handler: " + event);
                }
            }
        }
        this.replyProcessor.manageResponsesBatch(batchEvent.getBatchSequence(), batch);
    }

    void flush(int commitEventsToFlush) {
        this.commitSuicideIfNotMaster();
        try {
            long startFlushTimeInNs = System.nanoTime();
            if (commitEventsToFlush > 0) {
                this.writer.flush();
            }
            this.flushTimer.update(System.nanoTime() - startFlushTimeInNs);
            this.flushedCommitEventsHistogram.update(commitEventsToFlush);
        }
        catch (IOException e) {
            this.panicker.panic("Error persisting commit batch", e);
        }
        this.commitSuicideIfNotMaster();
    }

    private void commitSuicideIfNotMaster() {
        if (!this.leaseManager.stillInLeasePeriod()) {
            this.panicker.panic("Replica " + this.tsoHostAndPort + " lost mastership whilst flushing data. Committing suicide");
        }
    }

    void filterAndDissambiguateClientRetries(Batch batch) {
        int currentEventIdx = 0;
        while (currentEventIdx <= batch.getLastEventIdx()) {
            PersistEvent event = batch.get(currentEventIdx);
            if (event.getType() == PersistEvent.Type.COMMIT_RETRY) {
                this.retryProcessor.disambiguateRetryRequestHeuristically(event.getStartTimestamp(), event.getChannel(), event.getMonCtx());
                this.swapBatchElements(batch, currentEventIdx, batch.getLastEventIdx());
                batch.decreaseNumEvents();
                if (!batch.isEmpty()) continue;
                break;
            }
            ++currentEventIdx;
        }
    }

    private void swapBatchElements(Batch batch, int firstIdx, int lastIdx) {
        PersistEvent tmpEvent = batch.get(firstIdx);
        PersistEvent lastEventInBatch = batch.get(lastIdx);
        batch.set(firstIdx, lastEventInBatch);
        batch.set(lastIdx, tmpEvent);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

