/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.tools.ExtractText;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="extractxmp", header={"Extracts the xmp stream from a PDF document"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public class ExtractXMP
implements Callable<Integer> {
    private static final PrintStream SYSOUT = System.out;
    private static final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-page"}, description={"extract the XMP information from a specific page (1 based)"})
    private int page = 0;
    @CommandLine.Option(names={"-password"}, description={"the password for the PDF or certificate in keystore."}, arity="0..1", interactive=true)
    private String password = "";
    @CommandLine.Option(names={"-console"}, description={"Send text to console instead of file"})
    private boolean toConsole = false;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the exported text file"})
    private File outfile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new ExtractText()).execute(args);
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() {
        if (this.outfile == null) {
            String outPath = FilenameUtils.removeExtension((String)this.infile.getAbsolutePath()) + ".xml";
            this.outfile = new File(outPath);
        }
        try (PDDocument document = Loader.loadPDF((File)this.infile, (String)this.password);){
            PDMetadata meta;
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            if (this.page == 0) {
                meta = catalog.getMetadata();
            } else {
                if (this.page > document.getNumberOfPages()) {
                    SYSERR.println("Page " + this.page + " doesn't exist");
                    Integer n = 1;
                    return n;
                }
                meta = document.getPage(this.page - 1).getMetadata();
            }
            if (meta == null) {
                SYSERR.println("No XMP metadata available");
                Integer n = 1;
                return n;
            }
            try (PrintStream ps = this.toConsole ? SYSOUT : new PrintStream(this.outfile);){
                ps.write(meta.toByteArray());
                return 0;
            }
        }
        catch (IOException ioe) {
            SYSERR.println("Error extracting text for document [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
    }
}

