/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core;

import java.io.IOException;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.Constants;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.core.ContainerInvocation;
import org.apache.pluto.core.PortletContextManager;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.internal.InternalPortletConfig;
import org.apache.pluto.internal.InternalPortletContext;
import org.apache.pluto.internal.InternalPortletRequest;
import org.apache.pluto.internal.InternalPortletResponse;
import org.apache.pluto.internal.impl.ActionRequestImpl;
import org.apache.pluto.internal.impl.ActionResponseImpl;
import org.apache.pluto.internal.impl.RenderRequestImpl;
import org.apache.pluto.internal.impl.RenderResponseImpl;
import org.apache.pluto.spi.optional.AdministrativeRequestListener;
import org.apache.pluto.spi.optional.PortalAdministrationService;
import org.apache.pluto.spi.optional.PortletInvocationEvent;
import org.apache.pluto.spi.optional.PortletInvocationListener;

public class PortletServlet
extends HttpServlet {
    private String portletName;
    private Portlet portlet;
    private InternalPortletContext portletContext;
    private InternalPortletConfig portletConfig;

    public String getServletInfo() {
        return "Pluto PortletServlet [" + this.portletName + "]";
    }

    public void init() throws ServletException {
        super.init();
        this.portletName = this.getInitParameter("portlet-name");
        PortletContextManager mgr = PortletContextManager.getManager();
        try {
            String applicationId = mgr.register(this.getServletConfig());
            this.portletContext = (InternalPortletContext)mgr.getPortletContext(applicationId);
            this.portletConfig = (InternalPortletConfig)mgr.getPortletConfig(applicationId, this.portletName);
        }
        catch (PortletContainerException ex) {
            throw new ServletException((Throwable)ex);
        }
        PortletDD portletDD = this.portletConfig.getPortletDefinition();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(portletDD.getPortletClass());
            this.portlet = (Portlet)clazz.newInstance();
            this.portlet.init((PortletConfig)this.portletConfig);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new ServletException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new ServletException((Throwable)ex);
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            throw new ServletException((Throwable)ex);
        }
        catch (PortletException ex) {
            ex.printStackTrace();
            throw new ServletException((Throwable)ex);
        }
    }

    public void destroy() {
        PortletContextManager.getManager().remove(this.portletContext);
        if (this.portlet != null) {
            this.portlet.destroy();
        }
        super.destroy();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InternalPortletRequest portletRequest = null;
        InternalPortletResponse portletResponse = null;
        request.setAttribute("javax.portlet.config", (Object)this.portletConfig);
        Integer methodId = (Integer)request.getAttribute("org.apache.pluto.core.method");
        portletRequest = (InternalPortletRequest)request.getAttribute("javax.portlet.request");
        portletResponse = (InternalPortletResponse)request.getAttribute("javax.portlet.response");
        portletRequest.init(this.portletContext, request);
        PortletWindow window = ContainerInvocation.getInvocation().getPortletWindow();
        PortletInvocationEvent event = new PortletInvocationEvent(portletRequest, window, methodId);
        this.notify(event, true, null);
        try {
            try {
                if (methodId == Constants.METHOD_RENDER) {
                    RenderRequestImpl renderRequest = (RenderRequestImpl)portletRequest;
                    RenderResponseImpl renderResponse = (RenderResponseImpl)portletResponse;
                    this.portlet.render((RenderRequest)renderRequest, (RenderResponse)renderResponse);
                } else if (methodId == Constants.METHOD_ACTION) {
                    ActionRequestImpl actionRequest = (ActionRequestImpl)portletRequest;
                    ActionResponseImpl actionResponse = (ActionResponseImpl)portletResponse;
                    this.portlet.processAction((ActionRequest)actionRequest, (ActionResponse)actionResponse);
                } else if (methodId == Constants.METHOD_ADMIN) {
                    ContainerInvocation inv = ContainerInvocation.getInvocation();
                    PortalAdministrationService pas = inv.getPortletContainer().getOptionalContainerServices().getPortalAdministrationService();
                    Iterator it = pas.getAdministrativeRequestListeners().iterator();
                    while (it.hasNext()) {
                        AdministrativeRequestListener l = (AdministrativeRequestListener)it.next();
                        l.administer(portletRequest, portletResponse);
                    }
                } else if (methodId == Constants.METHOD_NOOP) {
                    // empty if block
                }
                this.notify(event, false, null);
            }
            catch (UnavailableException ex) {
                ex.printStackTrace();
                try {
                    this.portlet.destroy();
                    throw new javax.servlet.UnavailableException(ex.getMessage());
                }
                catch (Throwable th) {
                    // empty catch block
                }
                throw new javax.servlet.UnavailableException(ex.getMessage());
            }
            catch (PortletException ex) {
                this.notify(event, false, ex);
                ex.printStackTrace();
                throw new ServletException((Throwable)ex);
            }
            Object var13_19 = null;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            request.removeAttribute("javax.portlet.config");
            if (portletRequest == null) throw throwable;
            portletRequest.release();
            throw throwable;
        }
        request.removeAttribute("javax.portlet.config");
        if (portletRequest == null) return;
        portletRequest.release();
    }

    protected void notify(PortletInvocationEvent event, boolean pre, Throwable e) {
        ContainerInvocation inv = ContainerInvocation.getInvocation();
        PortalAdministrationService pas = inv.getPortletContainer().getOptionalContainerServices().getPortalAdministrationService();
        Iterator i = pas.getPortletInvocationListeners().iterator();
        while (i.hasNext()) {
            PortletInvocationListener listener = (PortletInvocationListener)i.next();
            if (pre) {
                listener.onBegin(event);
                continue;
            }
            if (e == null) {
                listener.onEnd(event);
                continue;
            }
            listener.onError(event, e);
        }
    }
}

