/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.SupportsDD;
import org.apache.pluto.internal.Configuration;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.internal.InternalRenderResponse;
import org.apache.pluto.internal.impl.PortletResponseImpl;
import org.apache.pluto.internal.impl.PortletURLImpl;
import org.apache.pluto.spi.PortalCallbackService;
import org.apache.pluto.util.ArgumentUtility;
import org.apache.pluto.util.NamespaceMapper;
import org.apache.pluto.util.StringManager;
import org.apache.pluto.util.StringUtils;
import org.apache.pluto.util.impl.NamespaceMapperImpl;

public class RenderResponseImpl
extends PortletResponseImpl
implements RenderResponse,
InternalRenderResponse {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$internal$impl$RenderResponseImpl == null ? (class$org$apache$pluto$internal$impl$RenderResponseImpl = RenderResponseImpl.class$("org.apache.pluto.internal.impl.RenderResponseImpl")) : class$org$apache$pluto$internal$impl$RenderResponseImpl));
    private static final StringManager EXCEPTIONS = StringManager.getManager((class$org$apache$pluto$internal$impl$RenderResponseImpl == null ? (class$org$apache$pluto$internal$impl$RenderResponseImpl = RenderResponseImpl.class$("org.apache.pluto.internal.impl.RenderResponseImpl")) : class$org$apache$pluto$internal$impl$RenderResponseImpl).getPackage().getName());
    private boolean included = false;
    private String currentContentType;
    private final NamespaceMapper mapper = new NamespaceMapperImpl();
    static /* synthetic */ Class class$org$apache$pluto$internal$impl$RenderResponseImpl;

    public RenderResponseImpl(PortletContainer container, InternalPortletWindow internalPortletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        super(container, internalPortletWindow, servletRequest, servletResponse);
    }

    public String getContentType() {
        return this.currentContentType;
    }

    public PortletURL createRenderURL() {
        return this.createURL(false);
    }

    public PortletURL createActionURL() {
        return this.createURL(true);
    }

    public String getNamespace() {
        String namespace = this.mapper.encode(this.getInternalPortletWindow().getId(), "");
        StringBuffer validNamespace = new StringBuffer();
        for (int i = 0; i < namespace.length(); ++i) {
            char ch = namespace.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                validNamespace.append(ch);
                continue;
            }
            validNamespace.append('_');
        }
        return validNamespace.toString();
    }

    public void setTitle(String title) {
        PortalCallbackService callback = this.getContainer().getRequiredContainerServices().getPortalCallbackService();
        callback.setTitle(this.getHttpServletRequest(), this.getInternalPortletWindow(), title);
    }

    public void setContentType(String contentType) throws IllegalArgumentException {
        ArgumentUtility.validateNotNull("contentType", contentType);
        String mimeType = StringUtils.getMimeTypeWithoutEncoding(contentType);
        if (!this.isValidContentType(mimeType)) {
            throw new IllegalArgumentException("Specified content type '" + mimeType + "' is not supported.");
        }
        this.getHttpServletResponse().setContentType(mimeType);
        this.currentContentType = mimeType;
    }

    public String getCharacterEncoding() {
        return this.getHttpServletResponse().getCharacterEncoding();
    }

    public OutputStream getPortletOutputStream() throws IOException, IllegalStateException {
        if (this.currentContentType == null) {
            String message = EXCEPTIONS.getString("error.contenttype.null");
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Current content type is not set.");
            }
            throw new IllegalStateException(message);
        }
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this.currentContentType == null) {
            String message = EXCEPTIONS.getString("error.contenttype.null");
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Current content type is not set.");
            }
            throw new IllegalStateException(message);
        }
        return super.getWriter();
    }

    public Locale getLocale() {
        return this.getHttpServletRequest().getLocale();
    }

    public void setBufferSize(int size) {
        if (!Configuration.isBufferingSupported()) {
            throw new IllegalStateException("portlet container does not support buffering");
        }
        this.getHttpServletResponse().setBufferSize(size);
    }

    public int getBufferSize() {
        if (Configuration.isBufferingSupported()) {
            return this.getHttpServletResponse().getBufferSize();
        }
        return 0;
    }

    public void flushBuffer() throws IOException {
        this.getHttpServletResponse().flushBuffer();
    }

    public void resetBuffer() {
        this.getHttpServletResponse().resetBuffer();
    }

    public boolean isCommitted() {
        return this.getHttpServletResponse().isCommitted();
    }

    public void reset() {
        this.getHttpServletResponse().reset();
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public String encodeRedirectUrl(String url) {
        if (this.included) {
            return null;
        }
        return super.encodeRedirectUrl(url);
    }

    public String encodeRedirectURL(String url) {
        if (this.included) {
            return null;
        }
        return super.encodeRedirectURL(url);
    }

    private PortletURL createURL(boolean isAction) {
        return new PortletURLImpl(this.getContainer(), this.getInternalPortletWindow(), this.getHttpServletRequest(), this.getHttpServletResponse(), isAction);
    }

    private boolean isValidContentType(String contentType) {
        boolean valid = false;
        PortletDD portletDD = this.getInternalPortletWindow().getPortletEntity().getPortletDefinition();
        Iterator it = portletDD.getSupports().iterator();
        while (!valid && it.hasNext()) {
            SupportsDD supportsDD = (SupportsDD)it.next();
            String supportedType = supportsDD.getMimeType();
            if (supportedType.equals(contentType)) {
                valid = true;
                continue;
            }
            if (supportedType.indexOf("*") < 0) continue;
            int index = supportedType.indexOf("/");
            String supportedPrefix = supportedType.substring(0, index);
            String supportedSuffix = supportedType.substring(index + 1);
            index = contentType.indexOf("/");
            String typePrefix = contentType.substring(0, index);
            String typeSuffix = contentType.substring(index + 1);
            if (!supportedPrefix.equals("*") && !supportedPrefix.equals(typePrefix) || !supportedSuffix.equals("*") && !supportedSuffix.equals(typeSuffix)) continue;
            valid = true;
        }
        return valid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

