/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFTableStyleInfo;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CreateTable {
    public static void main(String[] args) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = (XSSFSheet)wb.createSheet();
        XSSFTable table = sheet.createTable();
        table.setName("Test");
        table.setDisplayName("Test_Table");
        table.getCTTable().addNewTableStyleInfo();
        table.getCTTable().getTableStyleInfo().setName("TableStyleMedium2");
        XSSFTableStyleInfo style = (XSSFTableStyleInfo)table.getStyle();
        style.setName("TableStyleMedium2");
        style.setShowColumnStripes(false);
        style.setShowRowStripes(true);
        style.setFirstColumn(false);
        style.setLastColumn(false);
        style.setShowRowStripes(true);
        style.setShowColumnStripes(true);
        for (int i = 0; i < 3; ++i) {
            XSSFRow row = sheet.createRow(i);
            for (int j = 0; j < 3; ++j) {
                XSSFCell cell = row.createCell(j);
                if (i == 0) {
                    cell.setCellValue("Column" + (j + 1));
                    continue;
                }
                cell.setCellValue((double)((i + 1) * (j + 1)));
            }
        }
        table.addColumn();
        table.addColumn();
        table.addColumn();
        AreaReference reference = new AreaReference(new CellReference(0, 0), new CellReference(2, 2));
        table.setCellReferences(reference);
        FileOutputStream fileOut = new FileOutputStream("ooxml-table.xlsx");
        wb.write((OutputStream)fileOut);
        fileOut.close();
        wb.close();
    }
}

