/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.xddf.usermodel;

import org.apache.poi.util.Beta;
import org.apache.poi.util.Internal;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPatternFillProperties;

@Beta
public class XDDFPatternFillProperties implements XDDFFillProperties {
    private CTPatternFillProperties props;

    public XDDFPatternFillProperties() {
        this(CTPatternFillProperties.Factory.newInstance());
    }

    protected XDDFPatternFillProperties(CTPatternFillProperties properties) {
        this.props = properties;
    }

    @Internal
    public CTPatternFillProperties getXmlObject() {
        return props;
    }

    public PresetPattern getPresetPattern() {
        if (props.isSetPrst()) {
            return PresetPattern.valueOf(props.getPrst());
        } else {
            return null;
        }
    }

    public void setPresetPattern(PresetPattern pattern) {
        if (pattern == null) {
            if (props.isSetPrst()) {
                props.unsetPrst();
            }
        } else {
            props.setPrst(pattern.underlying);
        }
    }

    public XDDFColor getBackgroundColor() {
        if (props.isSetBgClr()) {
            return XDDFColor.forColorContainer(props.getBgClr());
        } else {
            return null;
        }
    }

    public void setBackgroundColor(XDDFColor color) {
        if (color == null) {
            if (props.isSetBgClr()) {
                props.unsetBgClr();
            }
        } else {
            props.setBgClr(color.getColorContainer());
        }
    }

    public XDDFColor getForegroundColor() {
        if (props.isSetFgClr()) {
            return XDDFColor.forColorContainer(props.getFgClr());
        } else {
            return null;
        }
    }

    public void setForegroundColor(XDDFColor color) {
        if (color == null) {
            if (props.isSetFgClr()) {
                props.unsetFgClr();
            }
        } else {
            props.setFgClr(color.getColorContainer());
        }
    }
}
