/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConsumeSchema
implements Schema<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(AutoConsumeSchema.class);
    private Schema<GenericRecord> schema;

    public void setSchema(Schema<GenericRecord> schema) {
        this.schema = schema;
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(null != this.schema, "Schema is not initialized before used");
    }

    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    public boolean supportSchemaVersioning() {
        return true;
    }

    public byte[] encode(GenericRecord message) {
        this.ensureSchemaInitialized();
        return this.schema.encode((Object)message);
    }

    public GenericRecord decode(byte[] bytes, byte[] schemaVersion) {
        this.ensureSchemaInitialized();
        return (GenericRecord)this.schema.decode(bytes, schemaVersion);
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schema.setSchemaInfoProvider(schemaInfoProvider);
    }

    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }

    public boolean requireFetchingSchemaInfo() {
        return true;
    }

    public void configureSchemaInfo(String topicName, String componentName, SchemaInfo schemaInfo) {
        if (schemaInfo.getType() != SchemaType.AVRO && schemaInfo.getType() != SchemaType.JSON) {
            throw new RuntimeException("Currently auto consume only works for topics with avro or json schemas");
        }
        GenericSchemaImpl genericSchema = GenericSchemaImpl.of(schemaInfo, false);
        this.setSchema(genericSchema);
        log.info("Configure {} schema for topic {} : {}", new Object[]{componentName, topicName, schemaInfo.getSchemaDefinition()});
    }

    public static Schema<?> getSchema(SchemaInfo schemaInfo) {
        switch (schemaInfo.getType()) {
            case INT8: {
                return ByteSchema.of();
            }
            case INT16: {
                return ShortSchema.of();
            }
            case INT32: {
                return IntSchema.of();
            }
            case INT64: {
                return LongSchema.of();
            }
            case STRING: {
                return StringSchema.utf8();
            }
            case FLOAT: {
                return FloatSchema.of();
            }
            case DOUBLE: {
                return DoubleSchema.of();
            }
            case BOOLEAN: {
                return BooleanSchema.of();
            }
            case BYTES: {
                return BytesSchema.of();
            }
            case DATE: {
                return DateSchema.of();
            }
            case TIME: {
                return TimeSchema.of();
            }
            case TIMESTAMP: {
                return TimestampSchema.of();
            }
            case JSON: 
            case AVRO: {
                return GenericSchemaImpl.of(schemaInfo);
            }
            case KEY_VALUE: {
                KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo);
                Schema<?> keySchema = AutoConsumeSchema.getSchema((SchemaInfo)kvSchemaInfo.getKey());
                Schema<?> valueSchema = AutoConsumeSchema.getSchema((SchemaInfo)kvSchemaInfo.getValue());
                return KeyValueSchema.of(keySchema, valueSchema);
            }
        }
        throw new IllegalArgumentException("Retrieve schema instance from schema info for type '" + schemaInfo.getType() + "' is not supported yet");
    }
}

