/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import java.util.BitSet;
import java.util.concurrent.locks.StampedLock;

public class ConcurrentBitSet
extends BitSet {
    private static final long serialVersionUID = 1L;
    private final StampedLock rwLock = new StampedLock();

    public ConcurrentBitSet(int nbits) {
        super(nbits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get(int bitIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isSet = super.get(bitIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isSet = super.get(bitIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return isSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int bitIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        super.set(bitIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                super.set(bitIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int fromIndex, int toIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        super.set(fromIndex, toIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                super.set(fromIndex, toIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextSetBit(int fromIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        int bit = super.nextSetBit(fromIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                bit = super.nextSetBit(fromIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextClearBit(int fromIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        int bit = super.nextClearBit(fromIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                bit = super.nextClearBit(fromIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int previousSetBit(int fromIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        int bit = super.previousSetBit(fromIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                bit = super.previousSetBit(fromIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int previousClearBit(int fromIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        int bit = super.previousClearBit(fromIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                bit = super.previousClearBit(fromIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isEmpty = super.isEmpty();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isEmpty = super.isEmpty();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return isEmpty;
    }
}

