/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.exceptions.JmsConnectionFailedException;
import org.apache.qpid.jms.message.JmsMessageIDBuilder;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderFuture;

public class JmsMessageProducer
implements AutoCloseable,
MessageProducer {
    protected final JmsSession session;
    protected final JmsConnection connection;
    protected JmsProducerInfo producerInfo;
    protected final boolean anonymousProducer;
    protected long deliveryDelay = 0L;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected boolean disableMessageId;
    protected boolean disableTimestamp;
    protected final AtomicLong messageSequence = new AtomicLong();
    protected final AtomicReference<Throwable> failureCause = new AtomicReference();

    protected JmsMessageProducer(JmsProducerId producerId, JmsSession session, JmsDestination destination) throws JMSException {
        this.session = session;
        this.connection = session.getConnection();
        this.anonymousProducer = destination == null;
        JmsMessageIDBuilder messageIDBuilder = session.getMessageIDPolicy().getMessageIDBuilder(session, destination);
        this.producerInfo = new JmsProducerInfo(producerId, messageIDBuilder);
        this.producerInfo.setDestination(destination);
        this.producerInfo.setPresettle(session.getPresettlePolicy().isProducerPresttled(session, destination));
        session.add(this);
        try {
            session.getConnection().createResource(this.producerInfo);
        }
        catch (JMSException jmse) {
            session.remove(this);
            throw jmse;
        }
    }

    @Override
    public void close() throws JMSException {
        if (!this.closed.get()) {
            this.doClose();
        }
    }

    protected void doClose() throws JMSException {
        this.session.checkIsCompletionThread();
        this.shutdown();
        try {
            this.connection.destroyResource(this.producerInfo);
        }
        catch (JmsConnectionFailedException jmsConnectionFailedException) {
            // empty catch block
        }
    }

    protected void shutdown() throws JMSException {
        this.shutdown(null);
    }

    protected void shutdown(Throwable cause) throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.producerInfo.setState(JmsResource.ResourceState.CLOSED);
            this.failureCause.set(cause);
            this.session.remove(this);
        }
    }

    public long getDeliveryDelay() throws JMSException {
        this.checkClosed();
        return this.deliveryDelay;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.producerInfo.getDestination();
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageId;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableTimestamp;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    public void send(Message message) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created without an explicit Destination");
        }
        this.sendMessage(this.producerInfo.getDestination(), message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        this.checkDestinationNotInvalid(destination);
        if (!this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created with an explicit Destination.");
        }
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive, null);
    }

    public void send(Message message, CompletionListener listener) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive, listener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) throws JMSException {
        this.checkClosed();
        if (this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created without an explicit Destination");
        }
        if (listener == null) {
            throw new IllegalArgumentException("JmsCompletetionListener cannot be null");
        }
        this.sendMessage(this.producerInfo.getDestination(), message, deliveryMode, priority, timeToLive, listener);
    }

    public void send(Destination destination, Message message, CompletionListener listener) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive, listener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) throws JMSException {
        this.checkClosed();
        this.checkDestinationNotInvalid(destination);
        if (!this.anonymousProducer) {
            throw new UnsupportedOperationException("Using this method is not supported on producers created with an explicit Destination.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("JmsCompletetionListener cannot be null");
        }
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive, listener);
    }

    private void checkDestinationNotInvalid(Destination destination) throws InvalidDestinationException {
        if (destination == null) {
            throw new InvalidDestinationException("Destination must not be null");
        }
    }

    private void sendMessage(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener listener) throws JMSException {
        this.session.send(this, destination, message, deliveryMode, priority, timeToLive, this.disableMessageId, this.disableTimestamp, this.deliveryDelay, listener);
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.checkClosed();
        this.deliveryDelay = deliveryDelay;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        switch (deliveryMode) {
            case 1: 
            case 2: {
                this.deliveryMode = deliveryMode;
                break;
            }
            default: {
                throw new JMSException(String.format("Invalid DeliveryMode specified: %d", deliveryMode));
            }
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageId = value;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableTimestamp = value;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        if (defaultPriority < 0 || defaultPriority > 9) {
            throw new JMSException(String.format("Priority value given {%d} is out of range (0..9)", defaultPriority));
        }
        this.priority = defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.timeToLive = timeToLive;
    }

    protected JmsProducerId getProducerId() {
        return this.producerInfo.getId();
    }

    protected long getNextMessageSequence() {
        return this.messageSequence.incrementAndGet();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            IllegalStateException jmsEx = null;
            if (this.getFailureCause() == null) {
                jmsEx = new IllegalStateException("The MessageProducer is closed");
            } else {
                jmsEx = new IllegalStateException("The MessageProducer was closed due to an unrecoverable error.");
                jmsEx.initCause(this.getFailureCause());
            }
            throw jmsEx;
        }
    }

    protected boolean isPresettled() {
        return this.producerInfo.isPresettle();
    }

    protected boolean isAnonymous() {
        return this.anonymousProducer;
    }

    protected JmsMessageIDBuilder getMessageIDBuilder() {
        return this.producerInfo.getMessageIDBuilder();
    }

    void setFailureCause(Throwable failureCause) {
        this.failureCause.set(failureCause);
    }

    Throwable getFailureCause() {
        if (this.failureCause.get() == null) {
            return this.session.getFailureCause();
        }
        return this.failureCause.get();
    }

    protected void onConnectionInterrupted() {
    }

    protected void onConnectionRecovery(Provider provider) throws Exception {
        if (!this.producerInfo.isClosed()) {
            ProviderFuture request = provider.newProviderFuture();
            try {
                provider.create(this.producerInfo, request);
                request.sync();
            }
            catch (IOException ioe) {
                if (this.connection.isCloseLinksThatFailOnReconnect()) {
                    this.session.producerClosed(this.producerInfo, ioe);
                }
                throw ioe;
            }
        }
    }

    protected void onConnectionRecovered(Provider provider) throws Exception {
    }

    protected void onConnectionRestored() {
    }
}

