/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.Reporter;
import org.apache.rat.config.AddLicenseHeaders;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.mp.AbstractRatMojo;
import org.apache.rat.mp.RatCheckException;
import org.apache.rat.report.claim.ClaimStatistic;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class RatCheckMojo
extends AbstractRatMojo {
    @Parameter(property="rat.outputFile", defaultValue="${project.build.directory}/rat.txt")
    private File reportFile;
    @Parameter(property="rat.scanHiddenDirectories", defaultValue="false")
    private boolean scanHiddenDirectories;
    @Parameter(property="rat.outputStyle", defaultValue="plain")
    private String reportStyle;
    @Parameter(property="rat.numUnapprovedLicenses", defaultValue="0")
    private int numUnapprovedLicenses;
    @Parameter(property="rat.addLicenseHeaders", defaultValue="false")
    private String addLicenseHeaders;
    @Parameter(property="rat.copyrightMessage")
    private String copyrightMessage;
    @Parameter(property="rat.ignoreErrors", defaultValue="false")
    private boolean ignoreErrors;
    @Parameter(property="rat.consoleOutput", defaultValue="true")
    private boolean consoleOutput;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"RAT will not execute since it is configured to be skipped via system property 'rat.skip'.");
            return;
        }
        ReportConfiguration config = this.getConfiguration();
        this.logLicenses(config.getLicenses(LicenseSetFactory.LicenseFilter.all));
        File parent = this.reportFile.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            throw new MojoExecutionException("Could not create report parent directory " + parent);
        }
        try {
            ClaimStatistic report = Reporter.report((ReportConfiguration)config);
            this.check(report, config);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void check(ClaimStatistic statistics, ReportConfiguration config) throws MojoFailureException {
        if (this.numUnapprovedLicenses > 0) {
            this.getLog().info((CharSequence)("You requested to accept " + this.numUnapprovedLicenses + " files with unapproved licenses."));
        }
        int numApproved = statistics.getNumApproved();
        this.getLog().info((CharSequence)("Rat check: Summary over all files. Unapproved: " + statistics.getNumUnApproved() + ", unknown: " + statistics.getNumUnknown() + ", generated: " + statistics.getNumGenerated() + ", approved: " + numApproved + (numApproved > 0 ? " licenses." : " license.")));
        if (this.numUnapprovedLicenses < statistics.getNumUnApproved()) {
            if (this.consoleOutput) {
                try {
                    config.setStyleSheet(Defaults.getUnapprovedLicensesStyleSheet());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    config.setOut(() -> baos);
                    Reporter.report((ReportConfiguration)config);
                    this.getLog().warn((CharSequence)baos.toString());
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Unable to print the files with unapproved licenses to the console.");
                }
            }
            String seeReport = " See RAT report in: " + this.reportFile;
            if (!this.ignoreErrors) {
                throw new RatCheckException("Too many files with unapproved license: " + statistics.getNumUnApproved() + seeReport);
            }
            this.getLog().warn((CharSequence)("Rat check: " + statistics.getNumUnApproved() + " files with unapproved licenses." + seeReport));
        }
    }

    @Override
    protected ReportConfiguration getConfiguration() throws MojoExecutionException {
        ReportConfiguration configuration = super.getConfiguration();
        if (StringUtils.isNotBlank((CharSequence)this.addLicenseHeaders)) {
            configuration.setAddLicenseHeaders(AddLicenseHeaders.valueOf((String)this.addLicenseHeaders.toUpperCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.copyrightMessage)) {
            configuration.setCopyrightMessage(this.copyrightMessage);
        }
        if (this.scanHiddenDirectories) {
            configuration.setDirectoryFilter(null);
        }
        if (this.reportFile != null) {
            if (!this.reportFile.exists()) {
                this.reportFile.getParentFile().mkdirs();
            }
            configuration.setOut(this.reportFile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.reportStyle)) {
            if ("xml".equalsIgnoreCase(this.reportStyle)) {
                configuration.setStyleReport(false);
            } else {
                configuration.setStyleReport(true);
                if (!"plain".equalsIgnoreCase(this.reportStyle)) {
                    configuration.setStyleSheet(() -> Files.newInputStream(Paths.get(this.reportStyle, new String[0]), new OpenOption[0]));
                }
            }
        }
        return configuration;
    }
}

