/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.concurrent.GuardedBy;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.io.grpc.InternalChannelz;

final class ChannelTracer {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Collection<InternalChannelz.ChannelTrace.Event> events;
    private final long channelCreationTimeNanos;
    @GuardedBy(value="lock")
    private int eventsLogged;

    ChannelTracer(final int maxEvents, long channelCreationTimeNanos, String channelType) {
        Preconditions.checkArgument(maxEvents > 0, "maxEvents must be greater than zero");
        Preconditions.checkNotNull(channelType, "channelType");
        this.events = new ArrayDeque<InternalChannelz.ChannelTrace.Event>(){

            @Override
            @GuardedBy(value="lock")
            public boolean add(InternalChannelz.ChannelTrace.Event event) {
                if (this.size() == maxEvents) {
                    this.removeFirst();
                }
                ChannelTracer.this.eventsLogged++;
                return super.add(event);
            }
        };
        this.channelCreationTimeNanos = channelCreationTimeNanos;
        this.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription(channelType + " created").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(channelCreationTimeNanos).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportEvent(InternalChannelz.ChannelTrace.Event event) {
        Object object = this.lock;
        synchronized (object) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBuilder(InternalChannelz.ChannelStats.Builder builder) {
        ArrayList<InternalChannelz.ChannelTrace.Event> eventsSnapshot;
        int eventsLoggedSnapshot;
        Object object = this.lock;
        synchronized (object) {
            eventsLoggedSnapshot = this.eventsLogged;
            eventsSnapshot = new ArrayList<InternalChannelz.ChannelTrace.Event>(this.events);
        }
        builder.setChannelTrace(new InternalChannelz.ChannelTrace.Builder().setNumEventsLogged(eventsLoggedSnapshot).setCreationTimeNanos(this.channelCreationTimeNanos).setEvents(eventsSnapshot).build());
    }
}

