/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.api.yaml;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.engine.YamlEngine;
import org.apache.shardingsphere.core.yaml.swapper.impl.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.yaml.config.YamlOrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.yaml.swapper.OrchestrationConfigurationYamlSwapper;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.OrchestrationShardingDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.yaml.YamlOrchestrationShardingRuleConfiguration;

public final class YamlOrchestrationShardingDataSourceFactory {
    private static final ShardingRuleConfigurationYamlSwapper SHARDING_RULE_SWAPPER = new ShardingRuleConfigurationYamlSwapper();
    private static final OrchestrationConfigurationYamlSwapper ORCHESTRATION_SWAPPER = new OrchestrationConfigurationYamlSwapper();

    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlOrchestrationShardingRuleConfiguration config = YamlOrchestrationShardingDataSourceFactory.unmarshal(yamlFile);
        return YamlOrchestrationShardingDataSourceFactory.createDataSource(config.getDataSources(), config.getShardingRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        YamlOrchestrationShardingRuleConfiguration config = YamlOrchestrationShardingDataSourceFactory.unmarshal(yamlFile);
        return YamlOrchestrationShardingDataSourceFactory.createDataSource(dataSourceMap, config.getShardingRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlOrchestrationShardingRuleConfiguration config = YamlOrchestrationShardingDataSourceFactory.unmarshal(yamlBytes);
        return YamlOrchestrationShardingDataSourceFactory.createDataSource(config.getDataSources(), config.getShardingRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        YamlOrchestrationShardingRuleConfiguration config = YamlOrchestrationShardingDataSourceFactory.unmarshal(yamlBytes);
        return YamlOrchestrationShardingDataSourceFactory.createDataSource(dataSourceMap, config.getShardingRule(), config.getProps(), config.getOrchestration());
    }

    private static DataSource createDataSource(Map<String, DataSource> dataSourceMap, YamlShardingRuleConfiguration yamlShardingRuleConfiguration, Properties props, YamlOrchestrationConfiguration yamlOrchestrationConfiguration) throws SQLException {
        if (null == yamlShardingRuleConfiguration) {
            return new OrchestrationShardingDataSource(ORCHESTRATION_SWAPPER.swap(yamlOrchestrationConfiguration));
        }
        ShardingDataSource shardingDataSource = new ShardingDataSource(dataSourceMap, new ShardingRule(SHARDING_RULE_SWAPPER.swap(yamlShardingRuleConfiguration), dataSourceMap.keySet()), props);
        return new OrchestrationShardingDataSource(shardingDataSource, ORCHESTRATION_SWAPPER.swap(yamlOrchestrationConfiguration));
    }

    private static YamlOrchestrationShardingRuleConfiguration unmarshal(File yamlFile) throws IOException {
        return (YamlOrchestrationShardingRuleConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlOrchestrationShardingRuleConfiguration.class);
    }

    private static YamlOrchestrationShardingRuleConfiguration unmarshal(byte[] yamlBytes) throws IOException {
        return (YamlOrchestrationShardingRuleConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlOrchestrationShardingRuleConfiguration.class);
    }

    private YamlOrchestrationShardingDataSourceFactory() {
    }
}

