/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.api.config.RuleConfiguration;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.core.config.DataSourceConfiguration;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.orchestration.config.OrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.internal.registry.ShardingOrchestrationFacade;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.DataSourceChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.EncryptRuleChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.PropertiesChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.service.ConfigurationService;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.EncryptDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.AbstractOrchestrationDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.util.DataSourceConverter;

public class OrchestrationEncryptDataSource
extends AbstractOrchestrationDataSource {
    private static final String ENCRYPT_DATASOURCE = "dataSource";
    private EncryptDataSource dataSource;

    public OrchestrationEncryptDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        ConfigurationService configService = this.getShardingOrchestrationFacade().getConfigService();
        EncryptRuleConfiguration encryptRuleConfig = configService.loadEncryptRuleConfiguration("logic_db");
        Preconditions.checkState((!encryptRuleConfig.getEncryptors().isEmpty() ? 1 : 0) != 0, (Object)"No available encrypt rule configuration to load.");
        Map dataSourceConfigurations = configService.loadDataSourceConfigurations("logic_db");
        this.checkDataSourceConfiguration(dataSourceConfigurations);
        this.dataSource = new EncryptDataSource(DataSourceConverter.getDataSourceMap(dataSourceConfigurations).values().iterator().next(), new EncryptRule(encryptRuleConfig), configService.loadProperties());
        this.initShardingOrchestrationFacade();
    }

    public OrchestrationEncryptDataSource(EncryptDataSource dataSource, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        this.dataSource = new EncryptDataSource(dataSource.getDataSource(), new EncryptRule(((EncryptRule)dataSource.getRuntimeContext().getRule()).getRuleConfiguration()), dataSource.getRuntimeContext().getProps().getProps());
        this.initShardingOrchestrationFacade(Collections.singletonMap("logic_db", DataSourceConverter.getDataSourceConfigurationMap(Collections.singletonMap(ENCRYPT_DATASOURCE, dataSource.getDataSource()))), this.getRuleConfigurationMap(), dataSource.getRuntimeContext().getProps().getProps());
    }

    private void checkDataSourceConfiguration(Map<String, DataSourceConfiguration> dataSourceConfigurations) {
        Preconditions.checkState((1 == dataSourceConfigurations.size() ? 1 : 0) != 0, (Object)String.format("There should be only one datasource for encrypt, but now has %d datasource(s)", dataSourceConfigurations.size()));
    }

    private Map<String, RuleConfiguration> getRuleConfigurationMap() {
        HashMap<String, RuleConfiguration> result = new HashMap<String, RuleConfiguration>(1);
        result.put("logic_db", (RuleConfiguration)((EncryptRule)this.dataSource.getRuntimeContext().getRule()).getRuleConfiguration());
        return result;
    }

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) {
        Map dataSourceConfigurations = dataSourceChangedEvent.getDataSourceConfigurations();
        this.dataSource.close();
        this.checkDataSourceConfiguration(dataSourceConfigurations);
        this.dataSource = new EncryptDataSource(DataSourceConverter.getDataSourceMap(dataSourceConfigurations).values().iterator().next(), (EncryptRule)this.dataSource.getRuntimeContext().getRule(), this.dataSource.getRuntimeContext().getProps().getProps());
        this.getDataSourceConfigurations().clear();
        this.getDataSourceConfigurations().putAll(dataSourceConfigurations);
    }

    @Subscribe
    public final synchronized void renew(EncryptRuleChangedEvent encryptRuleChangedEvent) {
        this.dataSource = new EncryptDataSource(this.dataSource.getDataSource(), new EncryptRule(encryptRuleChangedEvent.getEncryptRuleConfiguration()), this.dataSource.getRuntimeContext().getProps().getProps());
    }

    @Subscribe
    public final synchronized void renew(PropertiesChangedEvent propertiesChangedEvent) {
        this.dataSource = new EncryptDataSource(this.dataSource.getDataSource(), (EncryptRule)this.dataSource.getRuntimeContext().getRule(), propertiesChangedEvent.getProps());
    }

    protected EncryptDataSource getDataSource() {
        return this.dataSource;
    }
}

