/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.api.config.RuleConfiguration;
import org.apache.shardingsphere.api.config.masterslave.LoadBalanceStrategyConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.orchestration.config.OrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.internal.registry.ShardingOrchestrationFacade;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.DataSourceChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.MasterSlaveRuleChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.PropertiesChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.service.ConfigurationService;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.MasterSlaveDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.AbstractOrchestrationDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.util.DataSourceConverter;

public class OrchestrationMasterSlaveDataSource
extends AbstractOrchestrationDataSource {
    private MasterSlaveDataSource dataSource;

    public OrchestrationMasterSlaveDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        ConfigurationService configService = this.getShardingOrchestrationFacade().getConfigService();
        MasterSlaveRuleConfiguration masterSlaveRuleConfig = configService.loadMasterSlaveRuleConfiguration("logic_db");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)masterSlaveRuleConfig.getMasterDataSourceName()) ? 1 : 0) != 0, (Object)"No available master slave rule configuration to load.");
        this.dataSource = new MasterSlaveDataSource(DataSourceConverter.getDataSourceMap(configService.loadDataSourceConfigurations("logic_db")), (MasterSlaveRule)new OrchestrationMasterSlaveRule(masterSlaveRuleConfig), configService.loadProperties());
        this.initShardingOrchestrationFacade();
    }

    public OrchestrationMasterSlaveDataSource(MasterSlaveDataSource masterSlaveDataSource, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        this.dataSource = new MasterSlaveDataSource(masterSlaveDataSource.getDataSourceMap(), (MasterSlaveRule)new OrchestrationMasterSlaveRule(((MasterSlaveRule)masterSlaveDataSource.getRuntimeContext().getRule()).getRuleConfiguration()), masterSlaveDataSource.getRuntimeContext().getProps().getProps());
        this.initShardingOrchestrationFacade(Collections.singletonMap("logic_db", DataSourceConverter.getDataSourceConfigurationMap(this.dataSource.getDataSourceMap())), this.getRuleConfigurationMap(), this.dataSource.getRuntimeContext().getProps().getProps());
    }

    private Map<String, RuleConfiguration> getRuleConfigurationMap() {
        MasterSlaveRule masterSlaveRule = (MasterSlaveRule)this.dataSource.getRuntimeContext().getRule();
        HashMap<String, RuleConfiguration> result = new HashMap<String, RuleConfiguration>();
        result.put("logic_db", (RuleConfiguration)new MasterSlaveRuleConfiguration(masterSlaveRule.getName(), masterSlaveRule.getMasterDataSourceName(), masterSlaveRule.getSlaveDataSourceNames(), new LoadBalanceStrategyConfiguration(masterSlaveRule.getLoadBalanceAlgorithm().getType(), masterSlaveRule.getLoadBalanceAlgorithm().getProperties())));
        return result;
    }

    @Subscribe
    public final synchronized void renew(MasterSlaveRuleChangedEvent masterSlaveRuleChangedEvent) {
        this.dataSource = new MasterSlaveDataSource(this.dataSource.getDataSourceMap(), (MasterSlaveRule)new OrchestrationMasterSlaveRule(masterSlaveRuleChangedEvent.getMasterSlaveRuleConfiguration()), this.dataSource.getRuntimeContext().getProps().getProps());
    }

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) {
        Map dataSourceConfigurations = dataSourceChangedEvent.getDataSourceConfigurations();
        this.dataSource.close(this.getDeletedDataSources(dataSourceConfigurations));
        this.dataSource.close(this.getModifiedDataSources(dataSourceConfigurations).keySet());
        this.dataSource = new MasterSlaveDataSource(this.getChangedDataSources(this.dataSource.getDataSourceMap(), dataSourceConfigurations), (MasterSlaveRule)this.dataSource.getRuntimeContext().getRule(), this.dataSource.getRuntimeContext().getProps().getProps());
        this.getDataSourceConfigurations().clear();
        this.getDataSourceConfigurations().putAll(dataSourceConfigurations);
    }

    @Subscribe
    public final synchronized void renew(PropertiesChangedEvent propertiesChangedEvent) {
        this.dataSource = new MasterSlaveDataSource(this.dataSource.getDataSourceMap(), (MasterSlaveRule)this.dataSource.getRuntimeContext().getRule(), propertiesChangedEvent.getProps());
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if ("logic_db".equals(shardingSchema.getSchemaName())) {
            ((OrchestrationMasterSlaveRule)this.dataSource.getRuntimeContext().getRule()).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
        }
    }

    protected MasterSlaveDataSource getDataSource() {
        return this.dataSource;
    }
}

