/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableNameSchemaNameMapping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableNameSchemaNameMapping.class);
    private final Map<LogicTableName, String> mapping;

    public static Map<LogicTableName, String> convert(Map<String, ShardingSphereSchema> schemas) {
        HashMap<LogicTableName, String> result = new HashMap<LogicTableName, String>();
        schemas.forEach((schemaName, schema) -> {
            for (String each : schema.getAllTableNames()) {
                result.put(new LogicTableName(each), (String)schemaName);
            }
        });
        log.info("mapping={}", result);
        return result;
    }

    public String getSchemaName(String logicTableName) {
        return this.mapping.get(new LogicTableName(logicTableName));
    }

    public String getSchemaName(LogicTableName logicTableName) {
        return this.mapping.get(logicTableName);
    }

    @Generated
    public TableNameSchemaNameMapping(Map<LogicTableName, String> mapping) {
        this.mapping = mapping;
    }
}

