/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.parser.core;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryRuleSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CreateDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryRulesStatement;
import org.apache.shardingsphere.distsql.parser.autogen.DatabaseDiscoveryDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.DatabaseDiscoveryDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class DatabaseDiscoveryDistSQLStatementVisitor
extends DatabaseDiscoveryDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.CreateDatabaseDiscoveryRuleContext ctx) {
        return new CreateDatabaseDiscoveryRuleStatement((Collection)ctx.databaseDiscoveryRuleDefinition().stream().map(each -> (DatabaseDiscoveryRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.AlterDatabaseDiscoveryRuleContext ctx) {
        return new AlterDatabaseDiscoveryRuleStatement((Collection)ctx.databaseDiscoveryRuleDefinition().stream().map(each -> (DatabaseDiscoveryRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.DropDatabaseDiscoveryRuleContext ctx) {
        return new DropDatabaseDiscoveryRuleStatement((Collection)ctx.ruleName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowDatabaseDiscoveryRules(DatabaseDiscoveryDistSQLStatementParser.ShowDatabaseDiscoveryRulesContext ctx) {
        return new ShowDatabaseDiscoveryRulesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitDatabaseDiscoveryRuleDefinition(DatabaseDiscoveryDistSQLStatementParser.DatabaseDiscoveryRuleDefinitionContext ctx) {
        Collection dataSources = ctx.resources().resourceName().stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.toList());
        return new DatabaseDiscoveryRuleSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), dataSources, this.getIdentifierValue((ParseTree)ctx.algorithmDefinition().algorithmName()), this.getAlgorithmProperties(ctx.algorithmDefinition().algorithmProperties()));
    }

    private String getIdentifierValue(ParseTree context) {
        if (null == context) {
            return null;
        }
        return new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitSchemaName(DatabaseDiscoveryDistSQLStatementParser.SchemaNameContext ctx) {
        return new SchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(DatabaseDiscoveryDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmName()), null == ctx.algorithmProperties() ? new Properties() : this.getAlgorithmProperties(ctx.algorithmProperties()));
    }

    private Properties getAlgorithmProperties(DatabaseDiscoveryDistSQLStatementParser.AlgorithmPropertiesContext ctx) {
        Properties result = new Properties();
        for (DatabaseDiscoveryDistSQLStatementParser.AlgorithmPropertyContext each : ctx.algorithmProperty()) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }
}

