/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.kernel;

import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContextBuilder;
import org.apache.shardingsphere.infra.executor.sql.log.SQLLogger;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.SQLRewriteEntry;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.engine.SQLRouteEngine;

public final class KernelProcessor {
    public ExecutionContext generateExecutionContext(LogicSQL logicSQL, ShardingSphereDatabase database, ConfigurationProperties props) {
        RouteContext routeContext = this.route(logicSQL, database, props);
        SQLRewriteResult rewriteResult = this.rewrite(logicSQL, database, props, routeContext);
        ExecutionContext result = this.createExecutionContext(logicSQL, database, routeContext, rewriteResult);
        this.logSQL(logicSQL, props, result);
        return result;
    }

    private RouteContext route(LogicSQL logicSQL, ShardingSphereDatabase database, ConfigurationProperties props) {
        return new SQLRouteEngine(database.getRuleMetaData().getRules(), props).route(logicSQL, database);
    }

    private SQLRewriteResult rewrite(LogicSQL logicSQL, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        SQLRewriteEntry sqlRewriteEntry = new SQLRewriteEntry(database, props);
        return sqlRewriteEntry.rewrite(logicSQL.getSql(), logicSQL.getParameters(), logicSQL.getSqlStatementContext(), routeContext);
    }

    private ExecutionContext createExecutionContext(LogicSQL logicSQL, ShardingSphereDatabase database, RouteContext routeContext, SQLRewriteResult rewriteResult) {
        return new ExecutionContext(logicSQL, ExecutionContextBuilder.build((ShardingSphereDatabase)database, (SQLRewriteResult)rewriteResult, (SQLStatementContext)logicSQL.getSqlStatementContext()), routeContext);
    }

    private void logSQL(LogicSQL logicSQL, ConfigurationProperties props, ExecutionContext executionContext) {
        if (((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SHOW)).booleanValue()) {
            SQLLogger.logSQL((LogicSQL)logicSQL, (boolean)((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SIMPLE)), (ExecutionContext)executionContext);
        }
    }
}

