/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropViewStatement;

public final class DropViewStatementSchemaRefresher
implements MetaDataRefresher<DropViewStatement> {
    private static final String TYPE = DropViewStatement.class.getName();

    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, FederationDatabaseMetaData federationDatabaseMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, String schemaName, DropViewStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        SchemaAlteredEvent event = new SchemaAlteredEvent(database.getName(), schemaName);
        sqlStatement.getViews().forEach(each -> {
            ((ShardingSphereSchema)database.getSchemas().get(schemaName)).remove(each.getTableName().getIdentifier().getValue());
            event.getDroppedTables().add(each.getTableName().getIdentifier().getValue());
        });
        Collection rules = database.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (SimpleTableSegment each2 : sqlStatement.getViews()) {
            this.removeDataNode(rules, each2, schemaName);
        }
        return Optional.of(event);
    }

    private void removeDataNode(Collection<MutableDataNodeRule> rules, SimpleTableSegment tobeRemovedSegment, String schemaName) {
        for (MutableDataNodeRule each : rules) {
            each.remove(schemaName, tobeRemovedSegment.getTableName().getIdentifier().getValue());
        }
    }

    public String getType() {
        return TYPE;
    }
}

