/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.metadata.user.Grantee;

public final class Process {
    private final Map<ExecutionUnit, Statement> processStatements = new ConcurrentHashMap<ExecutionUnit, Statement>();
    private final String id;
    private final long startMillis;
    private final String sql;
    private final String databaseName;
    private final String username;
    private final String hostname;
    private final int totalUnitCount;
    private final AtomicInteger completedUnitCount;
    private final boolean idle;
    private final AtomicBoolean interrupted;

    public Process(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext) {
        this("", executionGroupContext, true);
    }

    public Process(String sql, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext) {
        this(sql, executionGroupContext, false);
    }

    private Process(String sql, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, boolean idle) {
        this.id = executionGroupContext.getReportContext().getProcessId();
        this.startMillis = System.currentTimeMillis();
        this.sql = sql;
        this.databaseName = executionGroupContext.getReportContext().getDatabaseName();
        Grantee grantee = executionGroupContext.getReportContext().getGrantee();
        this.username = null == grantee ? "" : grantee.getUsername();
        this.hostname = null == grantee ? "" : grantee.getHostname();
        this.totalUnitCount = this.getTotalUnitCount(executionGroupContext);
        this.processStatements.putAll(this.createProcessStatements(executionGroupContext));
        this.completedUnitCount = new AtomicInteger(0);
        this.idle = idle;
        this.interrupted = new AtomicBoolean();
    }

    private int getTotalUnitCount(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext) {
        int result = 0;
        for (ExecutionGroup<? extends SQLExecutionUnit> each : executionGroupContext.getInputGroups()) {
            result += each.getInputs().size();
        }
        return result;
    }

    private Map<ExecutionUnit, Statement> createProcessStatements(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext) {
        LinkedHashMap<ExecutionUnit, Statement> result = new LinkedHashMap<ExecutionUnit, Statement>();
        for (ExecutionGroup<? extends SQLExecutionUnit> each : executionGroupContext.getInputGroups()) {
            for (SQLExecutionUnit sQLExecutionUnit : each.getInputs()) {
                if (!(sQLExecutionUnit instanceof JDBCExecutionUnit)) continue;
                JDBCExecutionUnit jdbcExecutionUnit = (JDBCExecutionUnit)sQLExecutionUnit;
                result.put(jdbcExecutionUnit.getExecutionUnit(), jdbcExecutionUnit.getStorageResource());
            }
        }
        return result;
    }

    public void completeExecutionUnit() {
        this.completedUnitCount.incrementAndGet();
    }

    public int getCompletedUnitCount() {
        return this.completedUnitCount.get();
    }

    public boolean isInterrupted() {
        return this.interrupted.get();
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted.set(interrupted);
    }

    public void putProcessStatement(ExecutionUnit executionUnit, Statement statement) {
        this.processStatements.put(executionUnit, statement);
    }

    public void removeProcessStatement(ExecutionUnit executionUnit) {
        this.processStatements.remove(executionUnit);
    }

    @Generated
    public Process(String id, long startMillis, String sql, String databaseName, String username, String hostname, int totalUnitCount, AtomicInteger completedUnitCount, boolean idle, AtomicBoolean interrupted) {
        this.id = id;
        this.startMillis = startMillis;
        this.sql = sql;
        this.databaseName = databaseName;
        this.username = username;
        this.hostname = hostname;
        this.totalUnitCount = totalUnitCount;
        this.completedUnitCount = completedUnitCount;
        this.idle = idle;
        this.interrupted = interrupted;
    }

    @Generated
    public Map<ExecutionUnit, Statement> getProcessStatements() {
        return this.processStatements;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getStartMillis() {
        return this.startMillis;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public int getTotalUnitCount() {
        return this.totalUnitCount;
    }

    @Generated
    public boolean isIdle() {
        return this.idle;
    }

    @Generated
    public AtomicBoolean getInterrupted() {
        return this.interrupted;
    }
}

