/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.connection.SQLExecutionInterruptedException;
import org.apache.shardingsphere.infra.executor.sql.process.Process;

public final class ProcessRegistry {
    private static final ProcessRegistry INSTANCE = new ProcessRegistry();
    private final Map<String, Process> processes = new ConcurrentHashMap<String, Process>();

    public static ProcessRegistry getInstance() {
        return INSTANCE;
    }

    public void add(Process process) {
        if (this.isSameExecutionProcess(process)) {
            Process oldProcess = this.processes.get(process.getId());
            ShardingSpherePreconditions.checkState((!oldProcess.isInterrupted() ? 1 : 0) != 0, SQLExecutionInterruptedException::new);
            this.merge(oldProcess, process);
            return;
        }
        this.processes.put(process.getId(), process);
    }

    private boolean isSameExecutionProcess(Process process) {
        return !Strings.isNullOrEmpty((String)process.getSql()) && this.processes.containsKey(process.getId()) && this.processes.get(process.getId()).getSql().equalsIgnoreCase(process.getSql());
    }

    private void merge(Process oldProcess, Process newProcess) {
        int totalUnitCount = oldProcess.getTotalUnitCount() + newProcess.getTotalUnitCount();
        int completedUnitCount = oldProcess.getCompletedUnitCount() + newProcess.getCompletedUnitCount();
        boolean idle = oldProcess.isIdle() || newProcess.isIdle();
        boolean interrupted = oldProcess.isInterrupted() || newProcess.isInterrupted();
        Process process = new Process(oldProcess.getId(), oldProcess.getStartMillis(), oldProcess.getSql(), oldProcess.getDatabaseName(), oldProcess.getUsername(), oldProcess.getHostname(), totalUnitCount, new AtomicInteger(completedUnitCount), idle, new AtomicBoolean(interrupted));
        oldProcess.getProcessStatements().forEach(process::putProcessStatement);
        newProcess.getProcessStatements().forEach(process::putProcessStatement);
        this.processes.put(process.getId(), process);
    }

    public Process get(String id) {
        return this.processes.get(id);
    }

    public void remove(String id) {
        this.processes.remove(id);
    }

    public Collection<Process> listAll() {
        return this.processes.values();
    }

    @Generated
    private ProcessRegistry() {
    }
}

