/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.generator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.ConnectionContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;

public final class SQLTokenGenerators {
    private final Map<Class<?>, SQLTokenGenerator> sqlTokenGenerators = new LinkedHashMap();

    public void addAll(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        for (SQLTokenGenerator each : sqlTokenGenerators) {
            if (this.sqlTokenGenerators.containsKey(each.getClass())) continue;
            this.sqlTokenGenerators.put(each.getClass(), each);
        }
    }

    public List<SQLToken> generateSQLTokens(String databaseName, Map<String, ShardingSphereSchema> schemas, SQLStatementContext sqlStatementContext, List<Object> params, ConnectionContext connectionContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (SQLTokenGenerator each : this.sqlTokenGenerators.values()) {
            this.setUpSQLTokenGenerator(each, params, databaseName, schemas, result, connectionContext);
            if (each instanceof OptionalSQLTokenGenerator) {
                SQLToken sqlToken = ((OptionalSQLTokenGenerator)each).generateSQLToken(sqlStatementContext);
                if (result.contains(sqlToken)) continue;
                result.add(sqlToken);
                continue;
            }
            if (!(each instanceof CollectionSQLTokenGenerator)) continue;
            result.addAll(((CollectionSQLTokenGenerator)each).generateSQLTokens(sqlStatementContext));
        }
        return result;
    }

    private void setUpSQLTokenGenerator(SQLTokenGenerator sqlTokenGenerator, List<Object> params, String databaseName, Map<String, ShardingSphereSchema> schemas, List<SQLToken> previousSQLTokens, ConnectionContext connectionContext) {
        if (sqlTokenGenerator instanceof ParametersAware) {
            ((ParametersAware)((Object)sqlTokenGenerator)).setParameters(params);
        }
        if (sqlTokenGenerator instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)((Object)sqlTokenGenerator)).setSchemas(schemas);
            ((SchemaMetaDataAware)((Object)sqlTokenGenerator)).setDatabaseName(databaseName);
        }
        if (sqlTokenGenerator instanceof PreviousSQLTokensAware) {
            ((PreviousSQLTokensAware)((Object)sqlTokenGenerator)).setPreviousSQLTokens(previousSQLTokens);
        }
        if (sqlTokenGenerator instanceof ConnectionContextAware) {
            ((ConnectionContextAware)((Object)sqlTokenGenerator)).setConnectionContext(connectionContext);
        }
    }
}

