/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.expr;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InlineExpressionParser {
    private static final char SPLITTER = ',';
    private static final Map<String, Script> SCRIPTS = new ConcurrentHashMap<String, Script>();
    private static final GroovyShell SHELL = new GroovyShell();
    private final String inlineExpression;

    public static String handlePlaceHolder(String inlineExpression) {
        return inlineExpression.contains("$->{") ? inlineExpression.replaceAll("\\$->\\{", "\\$\\{") : inlineExpression;
    }

    public List<String> splitAndEvaluate() {
        return Strings.isNullOrEmpty((String)this.inlineExpression) ? Collections.emptyList() : this.flatten(this.evaluate(this.split()));
    }

    public Closure<?> evaluateClosure() {
        return (Closure)this.evaluate("{it -> \"" + this.inlineExpression + "\"}");
    }

    private List<Object> evaluate(List<String> inlineExpressions) {
        ArrayList<Object> result = new ArrayList<Object>(inlineExpressions.size());
        for (String each : inlineExpressions) {
            StringBuilder expression = new StringBuilder(InlineExpressionParser.handlePlaceHolder(each));
            if (!each.startsWith("\"")) {
                expression.insert(0, "\"");
            }
            if (!each.endsWith("\"")) {
                expression.append("\"");
            }
            result.add(this.evaluate(expression.toString()));
        }
        return result;
    }

    private Object evaluate(String expression) {
        Script script;
        if (SCRIPTS.containsKey(expression)) {
            script = SCRIPTS.get(expression);
        } else {
            script = SHELL.parse(expression);
            SCRIPTS.put(expression, script);
        }
        return script.run();
    }

    private List<String> split() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder segment = new StringBuilder();
        int bracketsDepth = 0;
        block5: for (int i = 0; i < this.inlineExpression.length(); ++i) {
            char each = this.inlineExpression.charAt(i);
            switch (each) {
                case ',': {
                    if (bracketsDepth > 0) {
                        segment.append(each);
                        continue block5;
                    }
                    result.add(segment.toString().trim());
                    segment.setLength(0);
                    continue block5;
                }
                case '$': {
                    if ('{' == this.inlineExpression.charAt(i + 1)) {
                        ++bracketsDepth;
                    }
                    if ("->{".equals(this.inlineExpression.substring(i + 1, i + 4))) {
                        ++bracketsDepth;
                    }
                    segment.append(each);
                    continue block5;
                }
                case '}': {
                    if (bracketsDepth > 0) {
                        --bracketsDepth;
                    }
                    segment.append(each);
                    continue block5;
                }
                default: {
                    segment.append(each);
                }
            }
        }
        if (segment.length() > 0) {
            result.add(segment.toString().trim());
        }
        return result;
    }

    private List<String> flatten(List<Object> segments) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object each : segments) {
            if (each instanceof GString) {
                result.addAll(this.assemblyCartesianSegments((GString)each));
                continue;
            }
            result.add(each.toString());
        }
        return result;
    }

    private List<String> assemblyCartesianSegments(GString segment) {
        Set<List<String>> cartesianValues = this.getCartesianValues(segment);
        ArrayList<String> result = new ArrayList<String>(cartesianValues.size());
        for (List<String> each : cartesianValues) {
            result.add(this.assemblySegment(each, segment));
        }
        return result;
    }

    private Set<List<String>> getCartesianValues(GString segment) {
        ArrayList<Set> result = new ArrayList<Set>(segment.getValues().length);
        for (Object each : segment.getValues()) {
            if (null == each) continue;
            if (each instanceof Collection) {
                result.add(((Collection)each).stream().map(Object::toString).collect(Collectors.toCollection(LinkedHashSet::new)));
                continue;
            }
            result.add(Sets.newHashSet((Object[])new String[]{each.toString()}));
        }
        return Sets.cartesianProduct(result);
    }

    private String assemblySegment(List<String> cartesianValue, GString segment) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < segment.getStrings().length; ++i) {
            result.append(segment.getStrings()[i]);
            if (i >= cartesianValue.size()) continue;
            result.append(cartesianValue.get(i));
        }
        return result.toString();
    }

    @Generated
    public InlineExpressionParser(String inlineExpression) {
        this.inlineExpression = inlineExpression;
    }
}

