/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.supporter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowRuleSegment;

public final class ShadowRuleStatementSupporter {
    public static List<String> getRuleNames(ShadowRuleConfiguration ruleConfig) {
        if (null == ruleConfig) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(ruleConfig.getDataSources().keySet());
    }

    public static List<String> getRuleNames(Collection<ShadowRuleSegment> segments) {
        if (segments.isEmpty()) {
            return Collections.emptyList();
        }
        return segments.stream().map(ShadowRuleSegment::getRuleName).collect(Collectors.toList());
    }

    public static List<String> getTableNames(ShadowRuleConfiguration ruleConfig) {
        if (null == ruleConfig) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(ruleConfig.getTables().keySet());
    }

    public static List<String> getTableNames(Collection<ShadowRuleSegment> segments) {
        if (segments.isEmpty()) {
            return Collections.emptyList();
        }
        return segments.stream().flatMap(each -> each.getShadowTableRules().keySet().stream()).collect(Collectors.toList());
    }

    public static List<String> getResourceNames(Collection<ShadowRuleSegment> segments) {
        if (segments.isEmpty()) {
            return Collections.emptyList();
        }
        return segments.stream().map(each -> Arrays.asList(each.getSource(), each.getShadow())).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<String> getAlgorithmNames(ShadowRuleConfiguration ruleConfig) {
        if (null == ruleConfig) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(ruleConfig.getShadowAlgorithms().keySet());
    }

    public static List<String> getAlgorithmNames(Collection<ShadowRuleSegment> segments) {
        if (segments.isEmpty()) {
            return Collections.emptyList();
        }
        return segments.stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).map(ShadowAlgorithmSegment::getAlgorithmName).collect(Collectors.toList());
    }

    public static List<ShadowAlgorithmSegment> getShadowAlgorithmSegment(Collection<ShadowRuleSegment> segments) {
        return segments.stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static ShadowTableConfiguration mergeConfiguration(ShadowTableConfiguration existingTableConfig, ShadowTableConfiguration newTableConfig) {
        existingTableConfig.getDataSourceNames().addAll(newTableConfig.getDataSourceNames());
        existingTableConfig.getShadowAlgorithmNames().addAll(newTableConfig.getShadowAlgorithmNames());
        return existingTableConfig;
    }
}

