/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.etcd;

import java.util.Objects;
import java.util.Properties;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.LogUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.client.etcd.EtcdClient;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class EtcdClientRegisterRepository
implements ShenyuClientRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdClientRegisterRepository.class);
    private EtcdClient client;

    public EtcdClientRegisterRepository() {
    }

    public EtcdClientRegisterRepository(ShenyuRegisterCenterConfig config) {
        this.init(config);
    }

    public void init(ShenyuRegisterCenterConfig config) {
        Properties props = config.getProps();
        long timeout = Long.parseLong(props.getProperty("etcdTimeout", "3000"));
        long ttl = Long.parseLong(props.getProperty("etcdTTL", "5"));
        this.client = new EtcdClient(config.getServerLists(), ttl, timeout);
    }

    public void close() {
        this.client.close();
    }

    public void persistInterface(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)metadata.getContextPath(), (String)metadata.getAppName());
        this.registerMetadata(rpcType, contextPath, metadata);
        LogUtils.info((Logger)LOGGER, (String)"{} etcd client register metadata success: {}", (Object[])new Object[]{rpcType, metadata});
    }

    public void persistURI(URIRegisterDTO registerDTO) {
        String rpcType = registerDTO.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)registerDTO.getContextPath(), (String)registerDTO.getAppName());
        this.registerURI(rpcType, contextPath, registerDTO);
        LogUtils.info((Logger)LOGGER, (String)"{} etcd client register uri success: {}", (Object[])new Object[]{rpcType, registerDTO});
    }

    private void registerMetadata(String rpcType, String contextPath, MetaDataRegisterDTO metadata) {
        String metadataNodeName = this.buildMetadataNodeName(metadata);
        String metaDataPath = RegisterPathConstants.buildMetaDataParentPath((String)rpcType, (String)contextPath);
        String realNode = RegisterPathConstants.buildRealNode((String)metaDataPath, (String)metadataNodeName);
        this.client.putEphemeral(realNode, GsonUtils.getInstance().toJson((Object)metadata));
        LOGGER.info("register metadata success: {}", (Object)realNode);
    }

    private void registerURI(String rpcType, String contextPath, URIRegisterDTO registerDTO) {
        String uriNodeName = this.buildURINodeName(registerDTO);
        String uriPath = RegisterPathConstants.buildURIParentPath((String)rpcType, (String)contextPath);
        String realNode = RegisterPathConstants.buildRealNode((String)uriPath, (String)uriNodeName);
        this.client.putEphemeral(realNode, GsonUtils.getInstance().toJson((Object)registerDTO));
        LOGGER.info("register uri data success: {}", (Object)realNode);
    }

    private String buildURINodeName(URIRegisterDTO registerDTO) {
        String host = registerDTO.getHost();
        int port = registerDTO.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    private String buildMetadataNodeName(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String nodeName = Objects.equals(RpcTypeEnum.HTTP.getName(), rpcType) || Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), rpcType) ? String.join((CharSequence)"-", metadata.getContextPath(), metadata.getRuleName().replace("/", "-")) : RegisterPathConstants.buildNodeName((String)metadata.getServiceName(), (String)metadata.getMethodName());
        return nodeName.startsWith("/") ? nodeName.substring(1) : nodeName;
    }
}

