/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.hazelcast.cache;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import org.apache.shiro.ShiroException;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MapCache;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.Initializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastCacheManager
implements CacheManager,
Initializable,
Destroyable {
    private static final Class<?> IMAP_CLASS;
    private static final MethodType GET_MAP_METHOD_TYPE;
    public static final Logger log;
    private boolean implicitlyCreated = false;
    private HazelcastInstance hazelcastInstance;
    private Config config;

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        try {
            MethodHandle getMapHandle = MethodHandles.lookup().bind(this.ensureHazelcastInstance(), "getMap", GET_MAP_METHOD_TYPE);
            Map map = getMapHandle.invoke(name);
            return new MapCache(name, map);
        }
        catch (Throwable e) {
            throw new CacheException("Unable to get IMap", e);
        }
    }

    protected HazelcastInstance ensureHazelcastInstance() {
        if (this.hazelcastInstance == null) {
            this.hazelcastInstance = this.createHazelcastInstance();
            this.implicitlyCreated = true;
        }
        return this.hazelcastInstance;
    }

    public void init() throws ShiroException {
        this.ensureHazelcastInstance();
    }

    protected HazelcastInstance createHazelcastInstance() {
        return Hazelcast.newHazelcastInstance((Config)this.config);
    }

    protected final boolean isImplicitlyCreated() {
        return this.implicitlyCreated;
    }

    public void destroy() throws Exception {
        if (this.implicitlyCreated) {
            try {
                this.hazelcastInstance.getLifecycleService().shutdown();
            }
            catch (Throwable t) {
                if (log.isWarnEnabled()) {
                    log.warn("Unable to cleanly shutdown implicitly created HazelcastInstance.  Ignoring (shutting down)...", t);
                }
            }
            finally {
                this.hazelcastInstance = null;
                this.implicitlyCreated = false;
            }
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    static {
        Class<?> klazz;
        try {
            klazz = HazelcastCacheManager.class.getClassLoader().loadClass("com.hazelcast.core.IMap");
        }
        catch (ClassNotFoundException e1) {
            try {
                klazz = HazelcastCacheManager.class.getClassLoader().loadClass("com.hazelcast.map.IMap");
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalStateException("Could not find Hazelcast v3 or v4 on classpath");
            }
        }
        IMAP_CLASS = klazz;
        GET_MAP_METHOD_TYPE = MethodType.methodType(IMAP_CLASS, String.class);
        log = LoggerFactory.getLogger(HazelcastCacheManager.class);
    }
}

