/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.json.ConfigurableBean;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.util.ConfigBundleSerialization;
import org.apache.sqoop.json.util.ConfigInputSerialization;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MToConfig;
import org.apache.sqoop.model.MValidator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConnectorBean
extends ConfigurableBean {
    public static final String CONNECTOR_LINK_CONFIG = "link-config";
    public static final String CONNECTOR_JOB_CONFIG = "job-config";
    private static final String CONNECTORS = "connectors";
    private List<MConnector> connectors;
    private Map<String, ResourceBundle> connectorConfigBundles;

    public ConnectorBean(List<MConnector> connectors, Map<String, ResourceBundle> bundles) {
        this.connectors = connectors;
        this.connectorConfigBundles = bundles;
    }

    public ConnectorBean() {
    }

    public List<MConnector> getConnectors() {
        return this.connectors;
    }

    public Map<String, ResourceBundle> getResourceBundles() {
        return this.connectorConfigBundles;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray connectorArray = this.extractConnectors(skipSensitive);
        JSONObject connectors = new JSONObject();
        connectors.put((Object)CONNECTORS, (Object)connectorArray);
        return connectors;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        JSONArray array = JSONUtils.getJSONArray(jsonObject, CONNECTORS);
        this.restoreConnectors(array);
    }

    protected JSONArray extractConnectors(boolean skipSensitive) {
        JSONArray connectorArray = new JSONArray();
        for (MConnector connector : this.connectors) {
            connectorArray.add((Object)this.extractConnector(skipSensitive, connector));
        }
        return connectorArray;
    }

    private JSONObject extractConnector(boolean skipSensitive, MConnector connector) {
        JSONObject connectorJsonObject = new JSONObject();
        connectorJsonObject.put((Object)"id", (Object)connector.getPersistenceId());
        connectorJsonObject.put((Object)"name", (Object)connector.getUniqueName());
        connectorJsonObject.put((Object)"class", (Object)connector.getClassName());
        connectorJsonObject.put((Object)"version", (Object)connector.getVersion());
        connectorJsonObject.put((Object)CONNECTOR_LINK_CONFIG, (Object)ConfigInputSerialization.extractConfigList(connector.getLinkConfig(), skipSensitive));
        connectorJsonObject.put((Object)CONNECTOR_JOB_CONFIG, (Object)new JSONObject());
        if (connector.getFromConfig() != null) {
            ((JSONObject)connectorJsonObject.get((Object)CONNECTOR_JOB_CONFIG)).put((Object)Direction.FROM, (Object)ConfigInputSerialization.extractConfigList(connector.getFromConfig(), skipSensitive));
        }
        if (connector.getToConfig() != null) {
            ((JSONObject)connectorJsonObject.get((Object)CONNECTOR_JOB_CONFIG)).put((Object)Direction.TO, (Object)ConfigInputSerialization.extractConfigList(connector.getToConfig(), skipSensitive));
        }
        connectorJsonObject.put((Object)"all-config-resources", (Object)new JSONObject());
        if (this.connectorConfigBundles != null && !this.connectorConfigBundles.isEmpty()) {
            connectorJsonObject.put((Object)"all-config-resources", (Object)ConfigBundleSerialization.extractConfigParamBundle(this.connectorConfigBundles.get(connector.getUniqueName())));
        }
        return connectorJsonObject;
    }

    protected void restoreConnectors(JSONArray array) {
        this.connectors = new ArrayList<MConnector>();
        this.connectorConfigBundles = new HashMap<String, ResourceBundle>();
        for (Object obj : array) {
            this.connectors.add(this.restoreConnector(obj));
        }
    }

    private MConnector restoreConnector(Object obj) {
        JSONObject object = (JSONObject)obj;
        long connectorId = JSONUtils.getLong(object, "id");
        String uniqueName = JSONUtils.getString(object, "name");
        String className = JSONUtils.getString(object, "class");
        String version = JSONUtils.getString(object, "version");
        JSONObject jsonLink = JSONUtils.getJSONObject(object, CONNECTOR_LINK_CONFIG);
        List<MConfig> linkConfigs = ConfigInputSerialization.restoreConfigs(JSONUtils.getJSONArray(jsonLink, "configs"));
        List<MValidator> linkValidators = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(jsonLink, "validators"));
        JSONObject jobConfigJson = JSONUtils.getJSONObject(object, CONNECTOR_JOB_CONFIG);
        JSONObject fromJobConfigJson = jobConfigJson.containsKey((Object)Direction.FROM.name()) ? JSONUtils.getJSONObject(jobConfigJson, Direction.FROM.name()) : null;
        JSONObject toJobConfigJson = jobConfigJson.containsKey((Object)Direction.TO.name()) ? JSONUtils.getJSONObject(jobConfigJson, Direction.TO.name()) : null;
        MFromConfig fromConfig = null;
        MToConfig toConfig = null;
        if (fromJobConfigJson != null) {
            List<MConfig> fromLinkConfigs = ConfigInputSerialization.restoreConfigs(JSONUtils.getJSONArray(fromJobConfigJson, "configs"));
            List<MValidator> fromLinkValidators = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(fromJobConfigJson, "validators"));
            fromConfig = new MFromConfig(fromLinkConfigs, fromLinkValidators);
        }
        if (toJobConfigJson != null) {
            List<MConfig> toLinkConfigs = ConfigInputSerialization.restoreConfigs(JSONUtils.getJSONArray(toJobConfigJson, "configs"));
            List<MValidator> toLinkValidators = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(toJobConfigJson, "validators"));
            toConfig = new MToConfig(toLinkConfigs, toLinkValidators);
        }
        MLinkConfig linkConfig = new MLinkConfig(linkConfigs, linkValidators);
        MConnector connector = new MConnector(uniqueName, className, version, linkConfig, fromConfig, toConfig);
        connector.setPersistenceId(connectorId);
        if (object.containsKey((Object)"all-config-resources")) {
            JSONObject jsonConfigBundle = JSONUtils.getJSONObject(object, "all-config-resources");
            this.connectorConfigBundles.put(uniqueName, ConfigBundleSerialization.restoreConfigParamBundle(jsonConfigBundle));
        }
        return connector;
    }
}

