/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.List;
import java.util.ResourceBundle;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.ConfigurableBean;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.util.ConfigBundleSerialization;
import org.apache.sqoop.json.util.ConfigInputSerialization;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MDriver;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MValidator;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DriverBean
extends ConfigurableBean {
    public static final String CURRENT_DRIVER_VERSION = "1";
    static final String DRIVER_JOB_CONFIG = "job-config";
    private MDriver driver;
    private ResourceBundle driverConfigBundle;

    public DriverBean(MDriver driver, ResourceBundle bundle) {
        this.driver = driver;
        this.driverConfigBundle = bundle;
    }

    public DriverBean() {
    }

    public MDriver getDriver() {
        return this.driver;
    }

    public ResourceBundle getDriverConfigResourceBundle() {
        return this.driverConfigBundle;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject configs = ConfigInputSerialization.extractConfigList(this.driver.getDriverConfig(), skipSensitive);
        JSONObject result = new JSONObject();
        result.put((Object)"id", (Object)this.driver.getPersistenceId());
        result.put((Object)"version", (Object)this.driver.getVersion());
        result.put((Object)DRIVER_JOB_CONFIG, (Object)configs);
        result.put((Object)"all-config-resources", (Object)ConfigBundleSerialization.extractConfigParamBundle(this.driverConfigBundle));
        return result;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        long id = JSONUtils.getLong(jsonObject, "id");
        String driverVersion = JSONUtils.getString(jsonObject, "version");
        JSONObject driverJobConfig = JSONUtils.getJSONObject(jsonObject, DRIVER_JOB_CONFIG);
        List<MConfig> driverConfigs = ConfigInputSerialization.restoreConfigs(JSONUtils.getJSONArray(driverJobConfig, "configs"));
        List<MValidator> driverValidators = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(driverJobConfig, "validators"));
        this.driver = new MDriver(new MDriverConfig(driverConfigs, driverValidators), driverVersion);
        this.driver.setPersistenceId(id);
        this.driverConfigBundle = ConfigBundleSerialization.restoreConfigParamBundle(JSONUtils.getJSONObject(jsonObject, "all-config-resources"));
    }
}

