/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.ConfigInputSerialization;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MToConfig;
import org.apache.sqoop.model.MValidator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobBean
implements JsonBean {
    static final String FROM_LINK_NAME = "from-link-name";
    static final String TO_LINK_NAME = "to-link-name";
    static final String FROM_CONNECTOR_NAME = "from-connector-name";
    static final String TO_CONNECTOR_NAME = "to-connector-name";
    static final String FROM_CONFIG_VALUES = "from-config-values";
    static final String TO_CONFIG_VALUES = "to-config-values";
    static final String DRIVER_CONFIG_VALUES = "driver-config-values";
    private static final String JOBS = "jobs";
    private List<MJob> jobs;
    private Map<String, ResourceBundle> connectorConfigBundles = new HashMap<String, ResourceBundle>();
    private ResourceBundle driverConfigBundle;

    public JobBean(MJob job) {
        this();
        this.jobs = new ArrayList<MJob>();
        this.jobs.add(job);
    }

    public JobBean(List<MJob> jobs) {
        this();
        this.jobs = jobs;
    }

    public JobBean() {
    }

    public void setDriverConfigBundle(ResourceBundle driverConfigBundle) {
        this.driverConfigBundle = driverConfigBundle;
    }

    public void addConnectorConfigBundle(String connectorName, ResourceBundle connectorConfigBundle) {
        this.connectorConfigBundles.put(connectorName, connectorConfigBundle);
    }

    public boolean hasConnectorConfigBundle(String connectorName) {
        return this.connectorConfigBundles.containsKey(connectorName);
    }

    public List<MJob> getJobs() {
        return this.jobs;
    }

    public ResourceBundle getConnectorConfigBundle(String connectorName) {
        return this.connectorConfigBundles.get(connectorName);
    }

    public ResourceBundle getDriverConfigBundle() {
        return this.driverConfigBundle;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray jobArray = this.extractJobs(skipSensitive);
        JSONObject jobs = new JSONObject();
        jobs.put((Object)JOBS, (Object)jobArray);
        return jobs;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        JSONArray array = JSONUtils.getJSONArray(jsonObject, JOBS);
        this.restoreJobs(array);
    }

    protected JSONArray extractJobs(boolean skipSensitive) {
        JSONArray jobArray = new JSONArray();
        for (MJob job : this.jobs) {
            jobArray.add((Object)this.extractJob(skipSensitive, job));
        }
        return jobArray;
    }

    private JSONObject extractJob(boolean skipSensitive, MJob job) {
        JSONObject object = new JSONObject();
        object.put((Object)"id", (Object)job.getPersistenceId());
        object.put((Object)"name", (Object)job.getName());
        object.put((Object)"enabled", (Object)job.getEnabled());
        object.put((Object)"creation-user", (Object)job.getCreationUser());
        object.put((Object)"creation-date", (Object)job.getCreationDate().getTime());
        object.put((Object)"update-user", (Object)job.getLastUpdateUser());
        object.put((Object)"update-date", (Object)job.getLastUpdateDate().getTime());
        object.put((Object)FROM_CONNECTOR_NAME, (Object)job.getFromConnectorName());
        object.put((Object)TO_CONNECTOR_NAME, (Object)job.getToConnectorName());
        object.put((Object)FROM_LINK_NAME, (Object)job.getFromLinkName());
        object.put((Object)TO_LINK_NAME, (Object)job.getToLinkName());
        MFromConfig fromConfigList = job.getFromJobConfig();
        object.put((Object)FROM_CONFIG_VALUES, (Object)ConfigInputSerialization.extractConfigList(fromConfigList, skipSensitive));
        MToConfig toConfigList = job.getToJobConfig();
        object.put((Object)TO_CONFIG_VALUES, (Object)ConfigInputSerialization.extractConfigList(toConfigList, skipSensitive));
        MDriverConfig driverConfigList = job.getDriverConfig();
        object.put((Object)DRIVER_CONFIG_VALUES, (Object)ConfigInputSerialization.extractConfigList(driverConfigList, skipSensitive));
        return object;
    }

    protected void restoreJobs(JSONArray array) {
        this.jobs = new ArrayList<MJob>();
        for (Object obj : array) {
            this.jobs.add(this.restoreJob(obj));
        }
    }

    private MJob restoreJob(Object obj) {
        JSONObject object = (JSONObject)obj;
        String fromConnectorName = JSONUtils.getString(object, FROM_CONNECTOR_NAME);
        String toConnectorName = JSONUtils.getString(object, TO_CONNECTOR_NAME);
        String fromLinkName = JSONUtils.getString(object, FROM_LINK_NAME);
        String toLinkName = JSONUtils.getString(object, TO_LINK_NAME);
        JSONObject fromConfigJson = JSONUtils.getJSONObject(object, FROM_CONFIG_VALUES);
        JSONObject toConfigJson = JSONUtils.getJSONObject(object, TO_CONFIG_VALUES);
        JSONObject driverConfigJson = JSONUtils.getJSONObject(object, DRIVER_CONFIG_VALUES);
        List<MConfig> fromConfigs = ConfigInputSerialization.restoreConfigs(JSONUtils.getJSONArray(fromConfigJson, "configs"));
        List<MValidator> fromValidators = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(fromConfigJson, "validators"));
        List<MConfig> toConfigs = ConfigInputSerialization.restoreConfigs(JSONUtils.getJSONArray(toConfigJson, "configs"));
        List<MValidator> toValidators = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(toConfigJson, "validators"));
        List<MConfig> driverConfigs = ConfigInputSerialization.restoreConfigs(JSONUtils.getJSONArray(driverConfigJson, "configs"));
        List<MValidator> driverValidators = ConfigInputSerialization.restoreValidator(JSONUtils.getJSONArray(driverConfigJson, "validators"));
        MJob job = new MJob(fromConnectorName, toConnectorName, fromLinkName, toLinkName, new MFromConfig(fromConfigs, fromValidators), new MToConfig(toConfigs, toValidators), new MDriverConfig(driverConfigs, driverValidators));
        job.setPersistenceId(JSONUtils.getLong(object, "id"));
        job.setName(JSONUtils.getString(object, "name"));
        job.setEnabled(JSONUtils.getBoolean(object, "enabled"));
        job.setCreationUser(JSONUtils.getString(object, "creation-user"));
        job.setCreationDate(new Date(JSONUtils.getLong(object, "creation-date")));
        job.setLastUpdateUser(JSONUtils.getString(object, "update-user"));
        job.setLastUpdateDate(new Date(JSONUtils.getLong(object, "update-date")));
        return job;
    }
}

