/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MValidator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MLongInput
extends MInput<Long> {
    public MLongInput(String name, boolean sensitive, InputEditable editable, String overrides, List<MValidator> mValidators) {
        super(name, sensitive, editable, overrides, mValidators);
    }

    @Override
    public String getUrlSafeValueString() {
        if (this.isEmpty()) {
            return "";
        }
        return ((Long)this.getValue()).toString();
    }

    @Override
    public void restoreFromUrlSafeValueString(String valueString) {
        if (valueString.isEmpty()) {
            this.setEmpty();
        }
        this.setValue(Long.valueOf(valueString));
    }

    @Override
    public MInputType getType() {
        return MInputType.LONG;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MLongInput)) {
            return false;
        }
        MLongInput i = (MLongInput)other;
        return this.getName().equals(i.getName());
    }

    @Override
    public int hashCode() {
        return 23 + 31 * this.getName().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public void setEmpty() {
        this.setValue(null);
    }

    @Override
    public MLongInput clone(boolean cloneWithValue) {
        MLongInput copy = new MLongInput(this.getName(), this.isSensitive(), this.getEditable(), this.getOverrides(), this.getCloneOfValidators());
        copy.setPersistenceId(this.getPersistenceId());
        if (cloneWithValue) {
            copy.setValue(this.getValue());
        }
        return copy;
    }
}

