/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MValidator;
import org.apache.sqoop.utils.UrlSafeUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class MMapInput
extends MInput<Map<String, String>> {
    public static final String SENSITIVE_VALUE_PLACEHOLDER = "";
    private final String sensitiveKeyPattern;

    public MMapInput(String name, boolean sensitive, InputEditable editable, String overrides, String sensitiveKeyPattern, List<MValidator> mValidators) {
        super(name, sensitive, editable, overrides, mValidators);
        this.sensitiveKeyPattern = sensitiveKeyPattern;
    }

    @Override
    public String getUrlSafeValueString() {
        Map valueMap = (Map)this.getValue();
        if (valueMap == null) {
            return null;
        }
        boolean first = true;
        StringBuilder vsb = new StringBuilder();
        for (Map.Entry entry : valueMap.entrySet()) {
            if (first) {
                first = false;
            } else {
                vsb.append("&");
            }
            vsb.append(UrlSafeUtils.urlEncode((String)entry.getKey())).append("=");
            vsb.append(entry.getValue() != null ? UrlSafeUtils.urlEncode((String)entry.getValue()) : SENSITIVE_VALUE_PLACEHOLDER);
        }
        return vsb.toString();
    }

    @Override
    public void restoreFromUrlSafeValueString(String valueString) {
        if (valueString == null) {
            this.setValue(null);
        } else {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            if (valueString.trim().length() > 0) {
                String[] valuePairs;
                for (String pair : valuePairs = valueString.split("&")) {
                    String[] nameAndVal = pair.split("=");
                    if (nameAndVal.length <= 0) continue;
                    String name = UrlSafeUtils.urlDecode(nameAndVal[0]);
                    String value = null;
                    if (nameAndVal.length > 1) {
                        value = nameAndVal[1];
                    }
                    if (value != null) {
                        value = UrlSafeUtils.urlDecode(value);
                    }
                    valueMap.put(name, value);
                }
            }
            this.setValue(valueMap);
        }
    }

    @Override
    public MInputType getType() {
        return MInputType.MAP;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MMapInput)) {
            return false;
        }
        MMapInput mmi = (MMapInput)other;
        return this.getName().equals(mmi.getName());
    }

    @Override
    public int hashCode() {
        return 23 + 31 * this.getName().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public void setEmpty() {
        this.setValue(null);
    }

    @Override
    public MMapInput clone(boolean cloneWithValue) {
        MMapInput copy = new MMapInput(this.getName(), this.isSensitive(), this.getEditable(), this.getOverrides(), this.getSensitiveKeyPattern(), this.getCloneOfValidators());
        copy.setPersistenceId(this.getPersistenceId());
        if (cloneWithValue && this.getValue() != null) {
            HashMap copyMap = new HashMap();
            Set entry = ((Map)this.getValue()).entrySet();
            for (Map.Entry itr : entry) {
                copyMap.put(itr.getKey(), itr.getValue());
            }
            copy.setValue(copyMap);
        }
        return copy;
    }

    public String getSensitiveKeyPattern() {
        return this.sensitiveKeyPattern;
    }

    public Map<String, String> getNonsenstiveValue() {
        if (this.isEmpty()) {
            return null;
        }
        HashMap<String, String> nonsensitveValue = new HashMap<String, String>();
        Pattern sensitivePattern = Pattern.compile(this.getSensitiveKeyPattern());
        for (Map.Entry entry : ((Map)this.getValue()).entrySet()) {
            if (sensitivePattern.matcher((CharSequence)entry.getKey()).matches()) {
                nonsensitveValue.put((String)entry.getKey(), SENSITIVE_VALUE_PLACEHOLDER);
                continue;
            }
            nonsensitveValue.put((String)entry.getKey(), (String)entry.getValue());
        }
        return nonsensitveValue;
    }
}

