/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.MPersistableEntity;
import org.apache.sqoop.model.MValidator;
import org.apache.sqoop.validation.Message;
import org.apache.sqoop.validation.Status;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class MValidatedElement
extends MPersistableEntity {
    private List<MValidator> mValidators;
    private List<Message> validationMessages;
    private Status validationStatus;

    public MValidatedElement(List<MValidator> mValidators) {
        this.mValidators = mValidators;
        this.resetValidationMessages();
    }

    public MValidatedElement(MValidatedElement other) {
        super(other);
        this.resetValidationMessages();
        this.mValidators = other.getCloneOfValidators();
        this.validationStatus = other.validationStatus;
        this.validationMessages.addAll(other.validationMessages);
    }

    public void resetValidationMessages() {
        this.validationStatus = Status.getDefault();
        this.validationMessages = new LinkedList<Message>();
    }

    public void addValidationMessage(Message msg) {
        this.validationMessages.add(msg);
        this.validationStatus = Status.getWorstStatus(this.validationStatus, msg.getStatus());
    }

    public void setValidationMessages(List<Message> messages) {
        this.validationMessages = messages;
        this.validationStatus = Status.getDefault();
        for (Message message : messages) {
            this.validationStatus = Status.getWorstStatus(this.validationStatus, message.getStatus());
        }
    }

    public List<Message> getValidationMessages() {
        return this.validationMessages;
    }

    public List<MValidator> getValidators() {
        return this.mValidators;
    }

    public Status getValidationStatus() {
        return this.validationStatus;
    }

    public List<MValidator> getCloneOfValidators() {
        if (this.getValidators() == null) {
            return null;
        }
        ArrayList<MValidator> copyValidators = new ArrayList<MValidator>();
        for (MValidator itr : this.getValidators()) {
            copyValidators.add((MValidator)itr.clone(true));
        }
        return copyValidators;
    }
}

