/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.schema.SchemaError;
import org.apache.sqoop.schema.type.Column;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Schema {
    private String name;
    private String note;
    private Date creationDate = new Date();
    private List<Column> columns = new ArrayList<Column>();
    private Set<String> columNames = new HashSet<String>();
    private Map<String, Integer> nameToIndexMap = new HashMap<String, Integer>();
    int columnIndex;

    private Schema() {
    }

    public Schema(String name) {
        this();
        if (StringUtils.isEmpty((String)name)) {
            throw new SqoopException((ErrorCode)SchemaError.SCHEMA_0006, "Schema: " + name);
        }
        this.name = name;
    }

    public Schema addColumn(Column column) {
        if (this.columNames.contains(column.getName())) {
            throw new SqoopException((ErrorCode)SchemaError.SCHEMA_0002, "Column: " + column);
        }
        this.columNames.add(column.getName());
        this.columns.add(column);
        this.nameToIndexMap.put(column.getName(), this.columnIndex);
        ++this.columnIndex;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        if (this.creationDate != null) {
            return new Date(this.creationDate.getTime());
        }
        return null;
    }

    public String getNote() {
        return this.note;
    }

    public Schema setNote(String note) {
        this.note = note;
        return this;
    }

    public Schema setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
        return this;
    }

    public Column[] getColumnsArray() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    public List<Column> getColumnsList() {
        return this.columns;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public Integer getColumnNameIndex(String name) {
        if (this.columNames.contains(name)) {
            return this.nameToIndexMap.get(name);
        }
        throw new SqoopException((ErrorCode)SchemaError.SCHEMA_0007, "Column: " + name);
    }

    public boolean isEmpty() {
        return this.columns.size() == 0;
    }

    public String toString() {
        return "Schema{" + "name=" + this.name + "" + ",columns=[\n\t" + StringUtils.join(this.columns, (String)",\n\t") + "]" + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)o;
        if (this.columns != null ? !this.columns.equals(schema.columns) : schema.columns != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(schema.name) : schema.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        return result;
    }
}

