/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema.type;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.schema.type.AbstractComplexType;
import org.apache.sqoop.schema.type.AbstractPrimitiveType;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.ColumnType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Map
extends AbstractComplexType {
    private AbstractPrimitiveType key;
    private Column value;

    public Map(String name, AbstractPrimitiveType key, Column value) {
        super(name);
        this.setKeyValue(key, value);
    }

    public Map(String name, Boolean nullable, AbstractPrimitiveType key, Column value) {
        super(name, nullable);
        this.setKeyValue(key, value);
    }

    private void setKeyValue(AbstractPrimitiveType key, Column value) {
        assert (key != null);
        assert (value != null);
        this.key = key;
        this.value = value;
    }

    @Override
    public ColumnType getType() {
        return ColumnType.MAP;
    }

    public AbstractPrimitiveType getKey() {
        return this.key;
    }

    public Column getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "Map{" + super.toString() + ",key=" + this.key + ",value=" + this.value + "}";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Map other = (Map)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

