/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class HostAndPortValidator
extends AbstractValidator<String> {
    @Override
    public void validate(String hostPortString) {
        if (Strings.isNullOrEmpty((String)hostPortString)) {
            this.addMessage(Status.ERROR, "Cannot be null nor empty");
            return;
        }
        boolean valid = false;
        try {
            URI uri = new URI("hdfs://" + hostPortString);
            valid = uri.getHost() != null && (!hostPortString.contains(":") || uri.getPort() > -1);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (!valid) {
            this.addMessage(Status.ERROR, "Invalid host and port string: " + hostPortString);
        }
    }
}

