/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthAccessTokenProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthRefreshTokenProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlan;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuth20UserAuthenticator;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuth20ServiceRegistry;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20ClientCredentialsGrantTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20IdTokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20PasswordGrantTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20RefreshTokenGrantTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20TokenResponseTypeAuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20AuthorizationCodeGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20ClientCredentialsGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20PasswordGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20RefreshTokenGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20CasCallbackUrlResolver;
import org.apereo.cas.support.oauth.web.audit.AccessTokenGrantRequestAuditResourceResolver;
import org.apereo.cas.support.oauth.web.audit.OAuth20UserProfileDataAuditResourceResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AccessTokenEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20CallbackAuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20UserProfileEndpointController;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.OAuth20DefaultCasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20DefaultTokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenClientCredentialsGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenPasswordGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRefreshTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationCodeAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ClientCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResourceOwnerCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20DefaultUserProfileViewRenderer;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.DefaultAccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuthAccessTokenExpirationPolicy;
import org.apereo.cas.ticket.code.DefaultOAuthCodeFactory;
import org.apereo.cas.ticket.code.OAuthCodeExpirationPolicy;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.refreshtoken.DefaultRefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.OAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.J2ESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.http.client.direct.DirectBasicAuthClient;
import org.pac4j.http.client.direct.DirectFormClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="oauthConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuthConfiguration
implements AuditTrailRecordResolutionPlanConfigurer,
ServiceRegistryExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasOAuthConfiguration.class);
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private AuditableExecution registeredServiceAccessStrategyEnforcer;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private ObjectProvider<CookieRetrievingCookieGenerator> ticketGrantingTicketCookieGenerator;

    @ConditionalOnMissingBean(name={"accessTokenResponseGenerator"})
    @Bean
    public AccessTokenResponseGenerator accessTokenResponseGenerator() {
        return new OAuth20AccessTokenResponseGenerator();
    }

    @ConditionalOnMissingBean(name={"oauthCasClientRedirectActionBuilder"})
    @Bean
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OAuth20DefaultCasClientRedirectActionBuilder();
    }

    @Bean
    public UrlResolver casCallbackUrlResolver() {
        return new OAuth20CasCallbackUrlResolver(OAuth20Utils.casOAuthCallbackUrl(this.casProperties.getServer().getPrefix()));
    }

    @Bean
    public Config oauthSecConfig() {
        CasConfiguration cfg = new CasConfiguration(this.casProperties.getServer().getLoginUrl());
        CasClient oauthCasClient = new CasClient(cfg);
        oauthCasClient.setRedirectActionBuilder(webContext -> this.oauthCasClientRedirectActionBuilder().build(oauthCasClient, webContext));
        oauthCasClient.setName("CasOAuthClient");
        oauthCasClient.setUrlResolver(this.casCallbackUrlResolver());
        Authenticator<UsernamePasswordCredentials> authenticator = this.oAuthClientAuthenticator();
        DirectBasicAuthClient basicAuthClient = new DirectBasicAuthClient(authenticator);
        basicAuthClient.setName("clientBasicAuth");
        DirectFormClient directFormClient = new DirectFormClient(authenticator);
        directFormClient.setName("clientForm");
        directFormClient.setUsernameParameter("client_id");
        directFormClient.setPasswordParameter("client_secret");
        DirectFormClient userFormClient = new DirectFormClient(this.oAuthUserAuthenticator());
        userFormClient.setName("userForm");
        Config config = new Config(OAuth20Utils.casOAuthCallbackUrl(this.casProperties.getServer().getPrefix()), new Client[]{oauthCasClient, basicAuthClient, directFormClient, userFormClient});
        config.setSessionStore((SessionStore)new J2ESessionStore());
        return config;
    }

    @ConditionalOnMissingBean(name={"consentApprovalViewResolver"})
    @Bean
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OAuth20ConsentApprovalViewResolver(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"callbackAuthorizeViewResolver"})
    @Bean
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OAuth20CallbackAuthorizeViewResolver(){};
    }

    @Bean
    public OAuth20CasClientRedirectActionBuilder defaultOAuthCasClientRedirectActionBuilder() {
        return new OAuth20DefaultCasClientRedirectActionBuilder();
    }

    @ConditionalOnMissingBean(name={"oAuthClientAuthenticator"})
    @Bean
    public Authenticator<UsernamePasswordCredentials> oAuthClientAuthenticator() {
        return new OAuth20ClientAuthenticator(this.servicesManager, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"oAuthUserAuthenticator"})
    @Bean
    public Authenticator<UsernamePasswordCredentials> oAuthUserAuthenticator() {
        return new OAuth20UserAuthenticator(this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory);
    }

    @ConditionalOnMissingBean(name={"oauthAccessTokenResponseGenerator"})
    @Bean
    public AccessTokenResponseGenerator oauthAccessTokenResponseGenerator() {
        return new OAuth20AccessTokenResponseGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultAccessTokenFactory"})
    public AccessTokenFactory defaultAccessTokenFactory() {
        return new DefaultAccessTokenFactory(this.accessTokenIdGenerator(), this.accessTokenExpirationPolicy());
    }

    @Bean
    @ConditionalOnMissingBean(name={"accessTokenExpirationPolicy"})
    public ExpirationPolicy accessTokenExpirationPolicy() {
        OAuthAccessTokenProperties oauth = this.casProperties.getAuthn().getOauth().getAccessToken();
        if (this.casProperties.getLogout().isRemoveDescendantTickets()) {
            return new OAuthAccessTokenExpirationPolicy(Beans.newDuration((String)oauth.getMaxTimeToLiveInSeconds()).getSeconds(), Beans.newDuration((String)oauth.getTimeToKillInSeconds()).getSeconds());
        }
        return new OAuthAccessTokenExpirationPolicy.OAuthAccessTokenSovereignExpirationPolicy(Beans.newDuration((String)oauth.getMaxTimeToLiveInSeconds()).getSeconds(), Beans.newDuration((String)oauth.getTimeToKillInSeconds()).getSeconds());
    }

    private ExpirationPolicy oAuthCodeExpirationPolicy() {
        OAuthProperties oauth = this.casProperties.getAuthn().getOauth();
        return new OAuthCodeExpirationPolicy(oauth.getCode().getNumberOfUses(), oauth.getCode().getTimeToKillInSeconds());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oAuthCodeIdGenerator"})
    public UniqueTicketIdGenerator oAuthCodeIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"refreshTokenIdGenerator"})
    public UniqueTicketIdGenerator refreshTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultOAuthCodeFactory"})
    public OAuthCodeFactory defaultOAuthCodeFactory() {
        return new DefaultOAuthCodeFactory(this.oAuthCodeIdGenerator(), this.oAuthCodeExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"profileScopeToAttributesFilter"})
    @Bean
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new DefaultOAuth20ProfileScopeToAttributesFilter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"callbackAuthorizeController"})
    @RefreshScope
    public OAuth20CallbackAuthorizeEndpointController callbackAuthorizeController() {
        return new OAuth20CallbackAuthorizeEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.oauthSecConfig(), this.callbackAuthorizeViewResolver(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable());
    }

    @ConditionalOnMissingBean(name={"oauthTokenGenerator"})
    @Bean
    @RefreshScope
    public OAuth20TokenGenerator oauthTokenGenerator() {
        return new OAuth20DefaultTokenGenerator(this.defaultAccessTokenFactory(), this.defaultRefreshTokenFactory(), this.ticketRegistry);
    }

    @Bean
    public Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors() {
        AccessTokenAuthorizationCodeGrantRequestExtractor authzCodeExt = new AccessTokenAuthorizationCodeGrantRequestExtractor(this.servicesManager, this.ticketRegistry, this.centralAuthenticationService, this.casProperties.getAuthn().getOauth(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory);
        AccessTokenRefreshTokenGrantRequestExtractor refreshTokenExt = new AccessTokenRefreshTokenGrantRequestExtractor(this.servicesManager, this.ticketRegistry, this.centralAuthenticationService, this.casProperties.getAuthn().getOauth(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory);
        OAuth20CasAuthenticationBuilder authenticationBuilder = this.oauthCasAuthenticationBuilder();
        AccessTokenPasswordGrantRequestExtractor pswExt = new AccessTokenPasswordGrantRequestExtractor(this.servicesManager, this.ticketRegistry, authenticationBuilder, this.centralAuthenticationService, this.casProperties.getAuthn().getOauth(), this.registeredServiceAccessStrategyEnforcer);
        AccessTokenClientCredentialsGrantRequestExtractor credsExt = new AccessTokenClientCredentialsGrantRequestExtractor(this.servicesManager, this.ticketRegistry, authenticationBuilder, this.centralAuthenticationService, this.casProperties.getAuthn().getOauth(), this.registeredServiceAccessStrategyEnforcer);
        return CollectionUtils.wrapList((Object[])new BaseAccessTokenGrantRequestExtractor[]{authzCodeExt, refreshTokenExt, pswExt, credsExt});
    }

    @ConditionalOnMissingBean(name={"accessTokenController"})
    @Bean
    public OAuth20AccessTokenEndpointController accessTokenController() {
        return new OAuth20AccessTokenEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.oauthTokenGenerator(), this.accessTokenResponseGenerator(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.accessTokenExpirationPolicy(), this.accessTokenGrantRequestExtractors(), this.oauthTokenRequestValidators());
    }

    @ConditionalOnMissingBean(name={"oauthUserProfileViewRenderer"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileViewRenderer oauthUserProfileViewRenderer() {
        return new OAuth20DefaultUserProfileViewRenderer(this.casProperties.getAuthn().getOauth());
    }

    @ConditionalOnMissingBean(name={"oAuth2UserProfileDataCreator"})
    @Bean
    public OAuth20UserProfileDataCreator oAuth2UserProfileDataCreator() {
        return new DefaultOAuth20UserProfileDataCreator(this.servicesManager, this.profileScopeToAttributesFilter());
    }

    @ConditionalOnMissingBean(name={"profileController"})
    @Bean
    public OAuth20UserProfileEndpointController profileController() {
        return new OAuth20UserProfileEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.oauthUserProfileViewRenderer(), this.oAuth2UserProfileDataCreator());
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationResponseBuilders"})
    @Bean
    @RefreshScope
    public Set<OAuth20AuthorizationResponseBuilder> oauthAuthorizationResponseBuilders() {
        Map builders = this.applicationContext.getBeansOfType(OAuth20AuthorizationResponseBuilder.class, false, true);
        return new HashSet<OAuth20AuthorizationResponseBuilder>(builders.values());
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationRequestValidators"})
    @Bean
    @RefreshScope
    public Set<OAuth20AuthorizationRequestValidator> oauthAuthorizationRequestValidators() {
        Map builders = this.applicationContext.getBeansOfType(OAuth20AuthorizationRequestValidator.class, false, true);
        return new HashSet<OAuth20AuthorizationRequestValidator>(builders.values());
    }

    @ConditionalOnMissingBean(name={"oauthTokenRequestValidators"})
    @Bean
    @RefreshScope
    public Collection<OAuth20TokenRequestValidator> oauthTokenRequestValidators() {
        ArrayList<OAuth20TokenRequestValidator> validators = new ArrayList<OAuth20TokenRequestValidator>();
        validators.add(new OAuth20AuthorizationCodeGrantTypeTokenRequestValidator(this.servicesManager, this.ticketRegistry, this.registeredServiceAccessStrategyEnforcer));
        validators.add(new OAuth20RefreshTokenGrantTypeTokenRequestValidator(this.registeredServiceAccessStrategyEnforcer, this.ticketRegistry));
        validators.add(new OAuth20PasswordGrantTypeTokenRequestValidator(this.registeredServiceAccessStrategyEnforcer, this.servicesManager, this.webApplicationServiceFactory));
        validators.add(new OAuth20ClientCredentialsGrantTypeTokenRequestValidator(this.servicesManager, this.registeredServiceAccessStrategyEnforcer, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory));
        return validators;
    }

    @ConditionalOnMissingBean(name={"oauthClientCredentialsGrantTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthClientCredentialsGrantTypeRequestValidator() {
        return new OAuth20ClientCredentialsGrantTypeAuthorizationRequestValidator(this.servicesManager, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationCodeResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthAuthorizationCodeResponseTypeRequestValidator() {
        return new OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator(this.servicesManager, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"oauthTokenResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthTokenResponseTypeRequestValidator() {
        return new OAuth20TokenResponseTypeAuthorizationRequestValidator(this.servicesManager, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"oauthIdTokenResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthIdTokenResponseTypeRequestValidator() {
        return new OAuth20IdTokenResponseTypeAuthorizationRequestValidator(this.servicesManager, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"oauthPasswordGrantTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthPasswordGrantTypeRequestValidator() {
        return new OAuth20PasswordGrantTypeAuthorizationRequestValidator(this.servicesManager, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"oauthRefreshTokenGrantTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationRequestValidator oauthRefreshTokenGrantTypeRequestValidator() {
        return new OAuth20RefreshTokenGrantTypeAuthorizationRequestValidator(this.servicesManager, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"oauthResourceOwnerCredentialsResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthResourceOwnerCredentialsResponseBuilder() {
        return new OAuth20ResourceOwnerCredentialsResponseBuilder(this.accessTokenResponseGenerator(), this.oauthTokenGenerator(), this.accessTokenExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"oauthClientCredentialsResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthClientCredentialsResponseBuilder() {
        return new OAuth20ClientCredentialsResponseBuilder(this.accessTokenResponseGenerator(), this.oauthTokenGenerator(), this.accessTokenExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"oauthTokenResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthTokenResponseBuilder() {
        return new OAuth20TokenAuthorizationResponseBuilder(this.oauthTokenGenerator(), this.accessTokenExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationCodeResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthAuthorizationCodeResponseBuilder() {
        return new OAuth20AuthorizationCodeAuthorizationResponseBuilder(this.ticketRegistry, this.defaultOAuthCodeFactory());
    }

    @ConditionalOnMissingBean(name={"authorizeController"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizeEndpointController authorizeController() {
        return new OAuth20AuthorizeEndpointController(this.servicesManager, this.ticketRegistry, this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.defaultOAuthCodeFactory(), this.consentApprovalViewResolver(), this.profileScopeToAttributesFilter(), this.casProperties, (CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator.getIfAvailable(), this.oauthCasAuthenticationBuilder(), this.oauthAuthorizationResponseBuilders(), this.oauthAuthorizationRequestValidators(), this.registeredServiceAccessStrategyEnforcer);
    }

    @ConditionalOnMissingBean(name={"oauthPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory oauthPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultRefreshTokenFactory"})
    public RefreshTokenFactory defaultRefreshTokenFactory() {
        return new DefaultRefreshTokenFactory(this.refreshTokenIdGenerator(), this.refreshTokenExpirationPolicy());
    }

    private ExpirationPolicy refreshTokenExpirationPolicy() {
        OAuthRefreshTokenProperties rtProps = this.casProperties.getAuthn().getOauth().getRefreshToken();
        long timeout = Beans.newDuration((String)rtProps.getTimeToKillInSeconds()).getSeconds();
        if (this.casProperties.getLogout().isRemoveDescendantTickets()) {
            return new OAuthRefreshTokenExpirationPolicy(timeout);
        }
        return new OAuthRefreshTokenExpirationPolicy.OAuthRefreshTokenSovereignExpirationPolicy(timeout);
    }

    @ConditionalOnMissingBean(name={"oauthCasAuthenticationBuilder"})
    @Bean
    @RefreshScope
    public OAuth20CasAuthenticationBuilder oauthCasAuthenticationBuilder() {
        return new OAuth20CasAuthenticationBuilder(this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"accessTokenIdGenerator"})
    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator accessTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    public void configureAuditTrailRecordResolutionPlan(AuditTrailRecordResolutionPlan plan) {
        plan.registerAuditActionResolver("OAUTH2_USER_PROFILE_DATA_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_FAILED"));
        plan.registerAuditResourceResolver("OAUTH2_USER_PROFILE_DATA_RESOURCE_RESOLVER", (AuditResourceResolver)new OAuth20UserProfileDataAuditResourceResolver());
        plan.registerAuditActionResolver("OAUTH2_ACCESS_TOKEN_REQUEST_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver("_CREATED", "_FAILED"));
        plan.registerAuditResourceResolver("OAUTH2_ACCESS_TOKEN_REQUEST_RESOURCE_RESOLVER", (AuditResourceResolver)new AccessTokenGrantRequestAuditResourceResolver());
    }

    @Bean
    public Service oauthCallbackService() {
        String oAuthCallbackUrl = this.casProperties.getServer().getPrefix() + "/oauth2.0" + '/' + "callbackAuthorize.*";
        return this.webApplicationServiceFactory.createService(oAuthCallbackUrl);
    }

    public void configureServiceRegistry(ServiceRegistryExecutionPlan plan) {
        RegexRegisteredService service = new RegexRegisteredService();
        service.setId(Math.abs(RandomUtils.getNativeInstance().nextLong()));
        service.setEvaluationOrder(0);
        service.setName(service.getClass().getSimpleName());
        service.setDescription("OAuth Authentication Callback Request URL");
        service.setServiceId(this.oauthCallbackService().getId());
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new DenyAllAttributeReleasePolicy());
        plan.registerServiceRegistry((ServiceRegistry)new OAuth20ServiceRegistry(new RegisteredService[]{service}));
    }
}

