/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.profile;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIdAwareProfileManager<U extends CommonProfile>
extends ProfileManager<U> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientIdAwareProfileManager.class);
    private static final String SESSION_CLIENT_ID = "oauthClientId";
    private final ServicesManager servicesManager;

    public ClientIdAwareProfileManager(WebContext context, SessionStore sessionStore, ServicesManager servicesManager) {
        super(context, sessionStore);
        this.servicesManager = servicesManager;
    }

    protected LinkedHashMap<String, U> retrieveAll(boolean readFromSession) {
        Set profiles = super.retrieveAll(readFromSession).entrySet();
        String clientId = this.getClientIdFromRequest();
        LinkedHashMap results = profiles.stream().filter(it -> ((CommonProfile)it.getValue()).getAuthenticationAttribute(SESSION_CLIENT_ID).equals(clientId)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
            throw new IllegalStateException("Duplicate key");
        }, LinkedHashMap::new));
        LOGGER.trace("Fetched profiles for this session are [{}]", (Object)results);
        return results;
    }

    public void save(boolean saveInSession, U profile, boolean multiProfile) {
        String clientId = this.getClientIdFromRequest();
        profile.addAuthenticationAttribute(SESSION_CLIENT_ID, (Object)clientId);
        super.save(saveInSession, profile, multiProfile);
    }

    private String getClientIdFromRequest() {
        String clientId = this.context.getRequestParameter("client_id");
        if (StringUtils.isBlank((CharSequence)clientId)) {
            String redirectUri = this.context.getRequestParameter("redirect_uri");
            OAuthRegisteredService svc = OAuth20Utils.getRegisteredOAuthServiceByRedirectUri(this.servicesManager, redirectUri);
            clientId = svc != null ? svc.getClientId() : "";
        }
        return clientId;
    }
}

