/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.BaseOAuth20TokenRequestValidator;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20PasswordGrantTypeTokenRequestValidator
extends BaseOAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20PasswordGrantTypeTokenRequestValidator.class);

    public OAuth20PasswordGrantTypeTokenRequestValidator(AuditableExecution registeredServiceAccessStrategyEnforcer, ServicesManager servicesManager, ServiceFactory webApplicationServiceServiceFactory) {
        super(registeredServiceAccessStrategyEnforcer, servicesManager, (ServiceFactory<WebApplicationService>)webApplicationServiceServiceFactory);
    }

    @Override
    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.PASSWORD;
    }

    @Override
    protected boolean validateInternal(J2EContext context, String grantType, ProfileManager manager, UserProfile uProfile) {
        HttpServletRequest request = context.getRequest();
        if (!HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"client_id")) {
            return false;
        }
        String clientId = request.getParameter("client_id");
        LOGGER.debug("Received grant type [{}] with client id [{}]", (Object)grantType, (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceServiceFactory.createService(registeredService.getServiceId());
        AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        accessResult.throwExceptionIfNeeded();
        if (!this.isGrantTypeSupportedBy(registeredService, grantType)) {
            LOGGER.warn("Requested grant type [{}] is not authorized by service definition [{}]", (Object)this.getGrantType(), (Object)registeredService.getServiceId());
            return false;
        }
        return true;
    }
}

