/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.theme.AbstractThemeResolver;

public class ChainingThemeResolver
extends AbstractThemeResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingThemeResolver.class);
    private final Set<ThemeResolver> chain = new LinkedHashSet<ThemeResolver>();

    public ChainingThemeResolver addResolver(ThemeResolver r) {
        this.chain.add(r);
        return this;
    }

    public String resolveThemeName(HttpServletRequest httpServletRequest) {
        for (ThemeResolver r : this.chain) {
            LOGGER.debug("Attempting to resolve theme via [{}]", (Object)r.getClass().getSimpleName());
            String resolverTheme = r.resolveThemeName(httpServletRequest);
            if (resolverTheme.equalsIgnoreCase(this.getDefaultThemeName())) continue;
            LOGGER.debug("Resolved theme [{}]", (Object)resolverTheme);
            return resolverTheme;
        }
        LOGGER.debug("No specific theme could be found. Using default theme [{}}", (Object)this.getDefaultThemeName());
        return this.getDefaultThemeName();
    }

    public void setThemeName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String s) {
    }
}

