/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.weaver.BCException;

public class InterTypeScope
extends ClassScope {
    ReferenceBinding onType;
    List aliases;
    Map<TypeVariableBinding, String> usedAliases;

    public InterTypeScope(Scope parent, ReferenceBinding onType) {
        super(parent, null);
        this.referenceContext = new TypeDeclaration(null);
        this.referenceContext.binding = this.makeSourceTypeBinding(onType);
        this.onType = onType;
    }

    public InterTypeScope(Scope parent, ReferenceBinding rb, List list) {
        this(parent, rb);
        this.aliases = list;
    }

    public String getAnyAliasForTypeVariableBinding(TypeVariableBinding tvb) {
        if (this.usedAliases == null) {
            return null;
        }
        return this.usedAliases.get(tvb);
    }

    private SourceTypeBinding makeSourceTypeBinding(ReferenceBinding onType) {
        if (onType instanceof SourceTypeBinding) {
            return (SourceTypeBinding)onType;
        }
        if (onType instanceof ParameterizedTypeBinding) {
            ReferenceBinding rb = ((ParameterizedTypeBinding)onType).type;
            if (rb instanceof SourceTypeBinding) {
                return (SourceTypeBinding)rb;
            }
            throw new BCException("In parameterized type " + onType + ", can't handle reference binding " + rb);
        }
        if (onType instanceof ProblemReferenceBinding) {
            return null;
        }
        if (onType instanceof TypeVariableBinding) {
            return null;
        }
        throw new BCException("can't handle: " + onType);
    }

    @Override
    public SourceTypeBinding invocationType() {
        return this.parent.enclosingSourceType();
    }

    @Override
    public int addDepth() {
        return 0;
    }

    @Override
    public TypeVariableBinding findTypeVariable(char[] name, SourceTypeBinding sourceType) {
        int aliased;
        if (sourceType == null) {
            return null;
        }
        String variableName = new String(name);
        int n = aliased = this.aliases == null ? -1 : this.aliases.indexOf(variableName);
        if (aliased != -1) {
            if (aliased > sourceType.typeVariables.length || sourceType.typeVariables.length == 0) {
                TypeVariableBinding tvb = new TypeVariableBinding("fake".toCharArray(), null, 0, this.environment());
                tvb.superclass = this.getJavaLangObject();
                tvb.fPackage = new PackageBinding(this.environment());
                return tvb;
            }
            TypeVariableBinding tvb = sourceType.typeVariables()[aliased];
            tvb.fPackage = sourceType.fPackage;
            if (this.usedAliases == null) {
                this.usedAliases = new HashMap<TypeVariableBinding, String>();
            }
            this.usedAliases.put(tvb, variableName);
            return tvb;
        }
        TypeVariableBinding variableBinding = sourceType.getTypeVariable(name);
        if (variableBinding == null) {
            variableBinding = this.parent.findTypeVariable(name, ((ClassScope)this.parent).referenceContext.binding);
        }
        return variableBinding;
    }

    public Map getRecoveryAliases() {
        return this.usedAliases;
    }

    @Override
    public boolean isInterTypeScope() {
        return true;
    }
}

