/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.disparity;

import boofcv.abst.disparity.StereoDisparity;
import boofcv.alg.disparity.DisparityBlockMatchRowFormat;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public abstract class WrapBaseBlockMatch<In extends ImageGray<In>, T extends ImageGray<T>, DI extends ImageGray<DI>>
implements StereoDisparity<In, DI> {
    DisparityBlockMatchRowFormat<T, DI> alg;
    DI disparity;
    @Nullable
    GrayF32 score;

    protected WrapBaseBlockMatch(DisparityBlockMatchRowFormat<T, DI> alg) {
        this.alg = alg;
    }

    @Override
    public void process(In imageLeft, In imageRight) {
        if (this.disparity == null || ((ImageGray)this.disparity).width != ((ImageGray)imageLeft).width || ((ImageGray)this.disparity).height != ((ImageGray)imageLeft).height) {
            this.disparity = GeneralizedImageOps.createSingleBand(this.alg.getDisparityType(), (int)((ImageGray)imageLeft).width, (int)((ImageGray)imageLeft).height);
            GImageMiscOps.fill(this.disparity, (double)this.getInvalidValue());
        }
        this.disparity.reshape(imageLeft);
        if (this.score != null) {
            this.score.reshape(this.disparity);
        }
        this._process(imageLeft, imageRight);
    }

    protected abstract void _process(In var1, In var2);

    public void setScoreEnabled(boolean enabled) {
        if (enabled && this.score != null) {
            return;
        }
        this.score = enabled ? new GrayF32(1, 1) : null;
    }

    @Override
    public DI getDisparity() {
        return this.disparity;
    }

    @Override
    @Nullable
    public GrayF32 getDisparityScore() {
        return this.score;
    }

    @Override
    public int getBorderX() {
        return this.alg.getBorderX();
    }

    @Override
    public int getBorderY() {
        return this.alg.getBorderY();
    }

    @Override
    public int getDisparityMin() {
        return this.alg.getDisparityMin();
    }

    @Override
    public int getDisparityRange() {
        return this.alg.getDisparityRange();
    }

    @Override
    public int getInvalidValue() {
        return this.getDisparityRange();
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.alg.getDisparityType();
    }

    public DisparityBlockMatchRowFormat<T, DI> getAlg() {
        return this.alg;
    }
}

