/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.select;

import boofcv.alg.disparity.block.SelectSparseStandardWta;
import boofcv.alg.disparity.block.score.DisparitySparseRectifiedScoreBM;

public class SelectSparseCorrelationWithChecksWta_F32
extends SelectSparseStandardWta<float[]> {
    protected float textureThreshold;

    public SelectSparseCorrelationWithChecksWta_F32(double texture, int tolRightToLeft) {
        super(0, texture, tolRightToLeft);
    }

    @Override
    protected void setTexture(double texture) {
        this.textureThreshold = (float)texture;
    }

    @Override
    public boolean select(DisparitySparseRectifiedScoreBM<float[], ?> scorer, int x, int y) {
        float scoreBest;
        if (!scorer.processLeftToRight(x, y)) {
            return false;
        }
        float[] scores = scorer.getScoreLtoR();
        int disparityRange = scorer.getLocalRangeLtoR();
        int bestDisparity = 0;
        float scoreWorst = scoreBest = scores[0];
        for (int i = 1; i < disparityRange; ++i) {
            float s = scores[i];
            if (s > scoreBest) {
                scoreBest = scores[i];
                bestDisparity = i;
                continue;
            }
            if (!(s < scoreWorst)) continue;
            scoreWorst = s;
        }
        if (this.textureThreshold > 0.0f && disparityRange >= 3) {
            int i;
            float secondBest = scoreWorst;
            for (i = 0; i < bestDisparity - 1; ++i) {
                if (!(scores[i] > secondBest)) continue;
                secondBest = scores[i];
            }
            for (i = bestDisparity + 2; i < disparityRange; ++i) {
                if (!(scores[i] > secondBest)) continue;
                secondBest = scores[i];
            }
            if ((scoreBest -= scoreWorst) - (secondBest -= scoreWorst) <= this.textureThreshold * secondBest) {
                return false;
            }
        }
        if (this.tolRightToLeft >= 0) {
            if (!scorer.processRightToLeft(x - bestDisparity - scorer.getDisparityMin(), y)) {
                return false;
            }
            float[] scoresRtoL = scorer.getScoreRtoL();
            int localRangeRtoL = scorer.getLocalRangeRtoL();
            int bestDisparityRtoL = 0;
            float scoreBestRtoL = scoresRtoL[0];
            for (int i = 1; i < localRangeRtoL; ++i) {
                float s = scoresRtoL[i];
                if (!(s > scoreBestRtoL)) continue;
                scoreBestRtoL = s;
                bestDisparityRtoL = i;
            }
            if (Math.abs(bestDisparityRtoL - bestDisparity) > this.tolRightToLeft) {
                return false;
            }
        }
        this.disparity = bestDisparity;
        return true;
    }
}

