/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block;

import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.alg.disparity.block.SelectDisparityWithChecksWta;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public abstract class SelectDisparityBasicWta<Array, Disparity extends ImageGray>
implements DisparitySelect<Array, Disparity> {
    protected Disparity imageDisparity;
    @Nullable
    protected GrayF32 imageScore;
    protected int disparityMin;
    protected int disparityMax;
    protected int disparityRange;
    protected int radiusX;
    protected int regionWidth;
    protected int imageWidth;
    protected SelectDisparityWithChecksWta.SaveScore funcSaveScore = (index, value) -> {};

    @Override
    public void configure(Disparity imageDisparity, @Nullable GrayF32 imageScore, int disparityMin, int disparityMax, int radiusX) {
        this.imageDisparity = imageDisparity;
        this.disparityMin = disparityMin;
        this.disparityMax = disparityMax;
        this.radiusX = radiusX;
        this.disparityRange = disparityMax - disparityMin + 1;
        this.regionWidth = radiusX * 2 + 1;
        this.imageWidth = ((ImageGray)imageDisparity).width;
        this.funcSaveScore = imageScore != null ? (index, value) -> {
            imageScore.data[index] = value;
        } : (index, value) -> {};
    }

    protected int disparityMaxAtColumnL2R(int col) {
        return Math.min(col, this.disparityMax);
    }
}

