/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.geo.rectify.DisparityParameters;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.ops.DConvertMatrixStruct;
import org.jetbrains.annotations.Nullable;

public class MultiBaselineDisparityErrors
implements VerbosePrint {
    public double fusedBaseline = 0.0;
    PixelTransform<Point2D_F64> pixelOrig_to_Undist;
    final DogArray<DisparityImage> images = new DogArray(DisparityImage::new, DisparityImage::reset);
    final FusedImage fused = new FusedImage();
    private final Homography2D_F64 rect = new Homography2D_F64();
    @Nullable
    PrintStream verbose;

    public void initialize(int width, int height, PixelTransform<Point2D_F64> dist_to_undist) {
        this.images.reset();
        this.fused.resize(width, height);
        this.pixelOrig_to_Undist = dist_to_undist;
    }

    public void addDisparity(GrayF32 disparity, GrayF32 score, DisparityParameters parameters, DMatrixRMaj undist_to_rect_px) {
        parameters.checkValidity();
        DisparityImage d = (DisparityImage)this.images.grow();
        d.disparity.setTo((ImageGray)disparity);
        d.score.setTo((ImageGray)score);
        d.undist_to_rect_px.setTo((DMatrixD1)undist_to_rect_px);
        d.parameters.setTo(parameters);
    }

    public boolean process(GrayF32 inverseDepth) {
        BoofMiscOps.checkTrue((!this.images.isEmpty() ? 1 : 0) != 0, (String)"No images have been added");
        inverseDepth.reshape(this.fused.width, this.fused.height);
        if (this.verbose != null) {
            this.verbose.printf("Fusing: shape=%dx%d images.size=%d\n", this.fused.width, this.fused.height, this.images.size);
        }
        this.fusedBaseline = 0.0;
        for (int i = 0; i < this.images.size; ++i) {
            if (!this.addToFusedImage((DisparityImage)this.images.get(i))) {
                return false;
            }
            this.fusedBaseline = Math.max(this.fusedBaseline, ((DisparityImage)this.images.get((int)i)).parameters.getBaseline());
        }
        if (!this.computeFused(inverseDepth)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Not a single valid pixel in fused disparity. images.size=" + this.images.size);
            }
            return false;
        }
        return true;
    }

    boolean addToFusedImage(DisparityImage image) {
        GrayF32 disparityImage = image.disparity;
        GrayF32 scores = image.score;
        DisparityParameters imageParam = image.parameters;
        float imageRange = imageParam.disparityRange;
        float imageMin = imageParam.disparityMin;
        double imageFocalX = imageParam.pinhole.fx;
        double imageBaseline = imageParam.baseline;
        CameraPinhole imagePinhole = imageParam.pinhole;
        DConvertMatrixStruct.convert((DMatrixRMaj)image.undist_to_rect_px, (DMatrix3x3)this.rect);
        Point2D_F64 undistPix = new Point2D_F64();
        Point2D_F64 rectPix = new Point2D_F64();
        for (int origPixY = 0; origPixY < this.fused.height; ++origPixY) {
            for (int origPixX = 0; origPixX < this.fused.width; ++origPixX) {
                float imageDisp;
                this.pixelOrig_to_Undist.compute(origPixX, origPixY, (Object)undistPix);
                HomographyPointOps_F64.transform((Homography2D_F64)this.rect, (double)undistPix.x, (double)undistPix.y, (Point2D_F64)rectPix);
                if (rectPix.x < 0.0 || rectPix.y < 0.0) continue;
                int rectPixX = (int)(rectPix.x + 0.5);
                int rectPixY = (int)(rectPix.y + 0.5);
                if (rectPixX >= disparityImage.width || rectPixY >= disparityImage.height || (imageDisp = disparityImage.unsafe_get(rectPixX, rectPixY)) >= imageRange) continue;
                float d = imageDisp + imageMin;
                double rectZ = imageBaseline * imageFocalX;
                double rectX = rectZ * ((double)rectPixX - imagePinhole.cx) / imagePinhole.fx;
                double rectY = rectZ * ((double)rectPixY - imagePinhole.cy) / imagePinhole.fy;
                double worldZ = this.dotRightCol(imageParam.rotateToRectified, rectX, rectY, rectZ);
                this.fused.get(origPixX, origPixY).add((float)((double)d / worldZ));
                this.fused.getScore(origPixX, origPixY).add(scores.get(rectPixX, rectPixY));
            }
        }
        return true;
    }

    double dotRightCol(DMatrixRMaj R, double x, double y, double z) {
        return R.data[2] * x + R.data[5] * y + R.data[8] * z;
    }

    boolean computeFused(GrayF32 inverseDepthImage) {
        boolean atLeastOneValidPixel = false;
        for (int y = 0; y < this.fused.height; ++y) {
            int indexOut = inverseDepthImage.startIndex + y * inverseDepthImage.stride;
            for (int x = 0; x < this.fused.width; ++x) {
                float inverseDepth;
                DogArray_F32 values = this.fused.get(x, y);
                if (values.size == 0) {
                    inverseDepth = -1.0f;
                } else if (values.size == 1) {
                    atLeastOneValidPixel = true;
                    inverseDepth = values.data[0];
                } else {
                    DogArray_F32 scores = this.fused.getScore(x, y);
                    inverseDepth = 0.0f;
                    float sumWeights = 0.0f;
                    for (int i = 0; i < values.size; ++i) {
                        float w = 1.0f / (1.0E-4f + scores.get(i));
                        inverseDepth += w * values.get(i);
                        sumWeights += w;
                    }
                    inverseDepth /= sumWeights;
                    atLeastOneValidPixel = true;
                }
                inverseDepthImage.data[indexOut++] = inverseDepth;
            }
        }
        return atLeastOneValidPixel;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public double getFusedBaseline() {
        return this.fusedBaseline;
    }

    public DogArray<DisparityImage> getImages() {
        return this.images;
    }

    public FusedImage getFused() {
        return this.fused;
    }

    static class FusedImage {
        public final DogArray<DogArray_F32> pixels = new DogArray(DogArray_F32::new, DogArray_F32::reset);
        public final DogArray<DogArray_F32> scores = new DogArray(DogArray_F32::new, DogArray_F32::reset);
        public int width;
        public int height;

        FusedImage() {
        }

        public DogArray_F32 get(int x, int y) {
            return (DogArray_F32)this.pixels.get(y * this.width + x);
        }

        public DogArray_F32 getScore(int x, int y) {
            return (DogArray_F32)this.scores.get(y * this.width + x);
        }

        public void resize(int width, int height) {
            this.pixels.reset().resize(width * height);
            this.scores.reset().resize(width * height);
            this.width = width;
            this.height = height;
        }
    }

    static class DisparityImage {
        public final GrayF32 disparity = new GrayF32(1, 1);
        public final GrayF32 score = new GrayF32(1, 1);
        public final DMatrixRMaj undist_to_rect_px = new DMatrixRMaj(3, 3);
        public final DisparityParameters parameters = new DisparityParameters();

        DisparityImage() {
        }

        public void reset() {
            this.disparity.reshape(1, 1);
            CommonOps_DDRM.fill((DMatrixD1)this.undist_to_rect_px, (double)0.0);
            this.parameters.reset();
        }
    }
}

